"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TryItButton = TryItButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _technical_preview_badge = require("../technical_preview_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/try_it_button/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TryItButton({
  isFeatureEnabled,
  linkLabel,
  onClick,
  popoverContent,
  promoLabel,
  isLoading,
  calloutId,
  hideThisContent
}) {
  var _core$application$cap;
  const [showTryCallout, setShowFastFilterTryCallout] = (0, _use_local_storage.useLocalStorage)(`apm.${calloutId}`, true);
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canEditAdvancedSettings = (_core$application$cap = core.application.capabilities.advancedSettings) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.save;
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  if (!showTryCallout) {
    return null;
  }
  function PromoLabel() {
    if (!promoLabel) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, promoLabel));
  }
  function Popover() {
    if (!popoverContent) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "apmPopoverButton",
        iconType: "info",
        "aria-label": _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.tryItHelperButtonLabel', {
          defaultMessage: 'Try it help'
        }),
        onClick: togglePopover,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 13
        }
      }),
      isOpen: isPopoverOpen,
      closePopover: togglePopover,
      anchorPosition: "upCenter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, popoverContent)));
  }
  function Link() {
    if (!linkLabel) {
      return null;
    }
    const linkComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmLink",
      disabled: isLoading || !canEditAdvancedSettings,
      onClick: onClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, linkLabel));
    if (!canEditAdvancedSettings) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          direction: "column",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          direction: "row",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "lock",
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 21
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.featureDisabled', {
          defaultMessage: 'This feature is currently disabled.'
        }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.admin', {
          defaultMessage: 'Please speak to you administrator to turn {featureEnabled} this feature.',
          values: {
            featureEnabled: isFeatureEnabled ? _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.admin.off', {
              defaultMessage: 'off'
            }) : _i18n.i18n.translate('xpack.apm.tryItButton.euiButtonIcon.admin.on', {
              defaultMessage: 'on'
            })
          }
        })))),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 9
        }
      }, linkComponent);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, linkComponent);
  }
  function Loading() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 13
      }
    })));
  }
  function HideThisButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: hideThisContent,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmHideThisButtonButton",
      iconType: "cross",
      "aria-label": hideThisContent,
      onClick: () => {
        setShowFastFilterTryCallout(false);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }), isFeatureEnabled ? null : /*#__PURE__*/_react.default.createElement(PromoLabel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 34
    }
  }), /*#__PURE__*/_react.default.createElement(Link, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(Popover, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(Loading, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(HideThisButton, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }));
}