"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallAccordionButton = WaterfallAccordionButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/trace_waterfall/waterfall_accordion_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function WaterfallAccordionButton({
  isOpen,
  onClick
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "m",
    onClick: onClick,
    iconType: isOpen ? 'fold' : 'unfold',
    "data-test-subj": "traceWaterfallAccordionButton",
    css: (0, _react2.css)`
        position: absolute;
        z-index: ${euiTheme.levels.menu};
        padding: ${euiTheme.size.m};
        width: auto;
      `,
    "aria-label": _i18n.i18n.translate('xpack.apm.waterfall.foldButton.ariaLabel', {
      defaultMessage: 'Click to {isAccordionOpen} the waterfall',
      values: {
        isAccordionOpen: isOpen ? _i18n.i18n.translate('xpack.apm.waterfall.foldButton.ariaLabel.fold', {
          defaultMessage: 'fold'
        }) : _i18n.i18n.translate('xpack.apm.waterfall.foldButton.ariaLabel.unfold', {
          defaultMessage: 'unfold'
        })
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  });
}