"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWaterfall = TraceWaterfall;
exports.convertTreeToList = convertTreeToList;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactVirtualized = require("react-virtualized");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _timeline = require("../charts/timeline");
var _trace_item_row = require("./trace_item_row");
var _trace_waterfall_context = require("./trace_waterfall_context");
var _trace_warning = require("./trace_warning");
var _waterfall_legends = require("./waterfall_legends");
var _waterfall_accordion_button = require("./waterfall_accordion_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/trace_waterfall/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TraceWaterfall({
  traceItems,
  errors,
  showAccordion = true,
  highlightedTraceId,
  onClick,
  onErrorClick,
  scrollElement,
  getRelatedErrorsHref,
  isEmbeddable = false,
  showLegend = false,
  serviceName,
  isFiltered
}) {
  return /*#__PURE__*/_react2.default.createElement(_trace_waterfall_context.TraceWaterfallContextProvider, {
    traceItems: traceItems,
    showAccordion: showAccordion,
    highlightedTraceId: highlightedTraceId,
    onClick: onClick,
    onErrorClick: onErrorClick,
    scrollElement: scrollElement,
    getRelatedErrorsHref: getRelatedErrorsHref,
    isEmbeddable: isEmbeddable,
    showLegend: showLegend,
    serviceName: serviceName,
    isFiltered: isFiltered,
    errors: errors,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_trace_warning.TraceWarning, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(TraceWaterfallComponent, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })));
}
function TraceWaterfallComponent() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    duration,
    margin: {
      left,
      right
    },
    isEmbeddable,
    legends,
    colorBy,
    showLegend,
    serviceName,
    errorMarks,
    showAccordion,
    isAccordionOpen,
    toggleAllAccordions
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, showLegend && serviceName && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_waterfall_legends.WaterfallLegends, {
    serviceName: serviceName,
    legends: legends,
    type: colorBy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    style: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
              display: flex;
              position: sticky;
              top: ${isEmbeddable ? '0px' : 'var(--euiFixedHeadersOffset, 0)'};
              z-index: ${euiTheme.levels.menu};
              background-color: ${euiTheme.colors.emptyShade};
              border-bottom: ${euiTheme.border.thin};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, showAccordion && /*#__PURE__*/_react2.default.createElement(_waterfall_accordion_button.WaterfallAccordionButton, {
    isOpen: isAccordionOpen,
    onClick: toggleAllAccordions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_timeline.TimelineAxisContainer, {
    xMax: duration,
    margins: {
      top: 40,
      left,
      right,
      bottom: 0
    },
    numberOfTicks: 3,
    marks: errorMarks,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_timeline.VerticalLinesContainer, {
    xMax: duration,
    margins: {
      top: 40,
      left,
      right,
      bottom: 0
    },
    marks: errorMarks,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
              position: relative;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(TraceTree, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  })))));
}
function TraceTree() {
  var _ref;
  const {
    traceWaterfallMap,
    traceWaterfall,
    scrollElement,
    accordionStatesMap,
    toggleAccordionState
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  const listRef = (0, _react2.useRef)(null);
  const rowHeightCache = (0, _react2.useRef)(new _reactVirtualized.CellMeasurerCache({
    fixedWidth: true,
    defaultHeight: _trace_item_row.ACCORDION_HEIGHT + _trace_item_row.BORDER_THICKNESS
  }));
  const visibleList = (0, _react2.useMemo)(() => convertTreeToList(traceWaterfallMap, accordionStatesMap, traceWaterfall[0]), [accordionStatesMap, traceWaterfall, traceWaterfallMap]);
  const rowRenderer = (0, _react2.useCallback)(({
    index,
    style,
    key,
    parent
  }) => {
    const item = visibleList[index];
    const children = traceWaterfallMap[item.id] || [];
    return /*#__PURE__*/_react2.default.createElement(VirtualRow, {
      key: key,
      index: index,
      style: style,
      parent: parent,
      rowHeightCache: rowHeightCache.current,
      item: item,
      childrenCount: children.length,
      accordionState: accordionStatesMap[item.id] || 'open',
      onToggle: toggleAccordionState,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 9
      }
    });
  }, [visibleList, traceWaterfallMap, accordionStatesMap, toggleAccordionState]);
  return /*#__PURE__*/_react2.default.createElement(_reactVirtualized.WindowScroller, {
    scrollElement: (_ref = scrollElement !== null && scrollElement !== void 0 ? scrollElement : document.getElementById(_coreChromeLayoutConstants.APP_MAIN_SCROLL_CONTAINER_ID)) !== null && _ref !== void 0 ? _ref : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  }, ({
    height,
    isScrolling,
    onChildScroll,
    scrollTop,
    registerChild
  }) => /*#__PURE__*/_react2.default.createElement(_reactVirtualized.AutoSizer, {
    disableHeight: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, ({
    width
  }) => /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "waterfall",
    ref: registerChild,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactVirtualized.List, {
    ref: listRef,
    autoHeight: true,
    height: height,
    isScrolling: isScrolling,
    onScroll: onChildScroll,
    scrollTop: scrollTop,
    width: width,
    rowCount: visibleList.length,
    deferredMeasurementCache: rowHeightCache.current,
    rowHeight: rowHeightCache.current.rowHeight,
    rowRenderer: rowRenderer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }))));
}
function VirtualRow({
  index,
  style,
  parent,
  rowHeightCache,
  item,
  childrenCount,
  accordionState,
  onToggle
}) {
  return /*#__PURE__*/_react2.default.createElement(_reactVirtualized.CellMeasurer, {
    cache: rowHeightCache,
    parent: parent,
    rowIndex: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_trace_item_row.TraceItemRow, {
    key: item.id,
    item: item,
    childrenCount: childrenCount,
    state: accordionState,
    onToggle: onToggle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  })));
}
function convertTreeToList(treeMap, accordionsState, root) {
  if (!root) {
    return [];
  }
  const result = [];
  const stack = [root];
  while (stack.length > 0) {
    const current = stack.pop();
    if (current) {
      const children = treeMap[current.id] || [];
      result.push(current);
      const state = accordionsState[current.id] || 'open';
      if (state === 'open') {
        for (let i = children.length - 1; i >= 0; i--) {
          stack.push(children[i]);
        }
      }
    }
  }
  return result;
}