"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorHeaderLink = InspectorHeaderLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/app_root/apm_header_action_menu/inspector_header_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function InspectorHeaderLink() {
  const {
    inspector
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    inspectorAdapters
  } = (0, _public3.useInspectorContext)();
  const {
    services: {
      uiSettings
    }
  } = (0, _public.useKibana)();
  const isInspectorEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_public2.enableInspectEsQueries);
  const inspect = () => {
    inspector.open(inspectorAdapters);
  };
  if (!isInspectorEnabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    onClick: inspect,
    "data-test-subj": "apmInspectHeaderLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.inspectButtonText', {
    defaultMessage: 'Inspect'
  }));
}