"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileTransactionOverview = MobileTransactionOverview;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _url_helpers = require("../../../shared/links/url_helpers");
var _get_kuery_with_mobile_filters = require("../../../../../common/utils/get_kuery_with_mobile_filters");
var _transaction_charts = require("./transaction_charts");
var _mobile_treemap = require("../charts/mobile_treemap");
var _transaction_overview_tabs = require("./transaction_overview_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/transaction_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MobileTransactionOverview() {
  const {
    path: {
      serviceName
    },
    query: {
      environment,
      rangeFrom,
      rangeTo,
      transactionType: transactionTypeFromUrl,
      device,
      osVersion,
      appVersion,
      netConnectionType,
      kuery,
      offset,
      comparisonEnabled,
      mobileSelectedTab
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/transactions');
  const kueryWithMobileFilters = (0, _get_kuery_with_mobile_filters.getKueryWithMobileFilters)({
    device,
    osVersion,
    appVersion,
    netConnectionType,
    kuery
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    transactionType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const history = (0, _reactRouterDom.useHistory)();

  // redirect to first transaction type
  if (!transactionTypeFromUrl && transactionType) {
    (0, _url_helpers.replace)(history, {
      query: {
        transactionType
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_mobile_treemap.MobileTreemap, {
    serviceName: serviceName,
    kuery: kueryWithMobileFilters,
    environment: environment,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_transaction_charts.MobileTransactionCharts, {
    transactionType: transactionType,
    serviceName: serviceName,
    kuery: kueryWithMobileFilters,
    environment: environment,
    start: start,
    end: end,
    offset: offset,
    comparisonEnabled: comparisonEnabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_overview_tabs.TransactionOverviewTabs, {
    environment: environment,
    kuery: kueryWithMobileFilters,
    start: start,
    end: end,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    mobileSelectedTab: mobileSelectedTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })));
}