"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataTierFilterCombined = getDataTierFilterCombined;
var _exclude_tiers_query = require("@kbn/observability-utils-common/es/queries/exclude_tiers_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDataTierFilterCombined({
  filter,
  excludedDataTiers
}) {
  if (!filter) {
    return excludedDataTiers !== null && excludedDataTiers !== void 0 && excludedDataTiers.length ? (0, _exclude_tiers_query.excludeTiersQuery)(excludedDataTiers)[0] : undefined;
  }
  return !excludedDataTiers ? filter : {
    bool: {
      must: [filter, ...(0, _exclude_tiers_query.excludeTiersQuery)(excludedDataTiers)]
    }
  };
}