"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processRunResults = processRunResults;
var _last_run_status = require("../../lib/last_run_status");
var _result_type = require("../../lib/result_type");
var _rule_execution_status = require("../../lib/rule_execution_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processRunResults({
  logger,
  logPrefix,
  result,
  runDate,
  runRuleResult
}) {
  // Getting executionStatus for backwards compatibility
  const {
    status: executionStatus
  } = (0, _result_type.map)(runRuleResult, _runRuleResult => (0, _rule_execution_status.executionStatusFromState)({
    runRuleResult: _runRuleResult,
    lastExecutionDate: runDate,
    ruleResultService: result
  }), err => (0, _rule_execution_status.executionStatusFromError)(err, runDate));

  // New consolidated statuses for lastRun
  const {
    lastRun,
    metrics: executionMetrics
  } = (0, _result_type.map)(runRuleResult, ({
    metrics
  }) => (0, _last_run_status.lastRunFromState)(metrics, result), err => (0, _last_run_status.lastRunFromError)(err));
  if (logger && logger.isLevelEnabled('debug')) {
    logger.debug(`deprecated ruleRunStatus for ${logPrefix}: ${JSON.stringify(executionStatus)}`);
    logger.debug(`ruleRunStatus for ${logPrefix}: ${JSON.stringify(lastRun)}`);
    if (executionMetrics) {
      logger.debug(`ruleRunMetrics for ${logPrefix}: ${JSON.stringify(executionMetrics)}`);
    }
  }
  let outcome = 'success';
  if (executionStatus.status === 'ok' || executionStatus.status === 'active') {
    outcome = 'success';
  } else if (executionStatus.status === 'error' || executionStatus.status === 'unknown') {
    outcome = 'failure';
  } else if (lastRun.outcome === 'succeeded') {
    outcome = 'success';
  } else if (lastRun.outcome === 'failed') {
    outcome = 'failure';
  }
  return {
    executionStatus,
    executionMetrics,
    lastRun,
    outcome
  };
}