"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMaxMuteUnmuteInstances = exports.MAX_MUTE_INSTANCES = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_MUTE_INSTANCES = exports.MAX_MUTE_INSTANCES = 100;
const validateMaxMuteUnmuteInstances = body => {
  if (getTotalAlertInstances(body) > MAX_MUTE_INSTANCES) {
    throw _boom.default.badRequest(`The total number of alert instances to mute cannot exceed ${MAX_MUTE_INSTANCES}.`);
  }
};
exports.validateMaxMuteUnmuteInstances = validateMaxMuteUnmuteInstances;
const getTotalAlertInstances = body => {
  return body.rules.reduce((acc, rule) => acc + rule.alert_instance_ids.length, 0);
};