"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleIdsWithGapsResponseSchema = exports.getRuleIdsWithGapsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleIdsWithGapsParamsSchema = exports.getRuleIdsWithGapsParamsSchema = _configSchema.schema.object({
  start: _configSchema.schema.maybe(_configSchema.schema.string()),
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  // Filters the underlying gap documents before aggregation. Matches the raw
  // per-gap statuses.
  statuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.gapStatus.UNFILLED), _configSchema.schema.literal(_common.gapStatus.PARTIALLY_FILLED), _configSchema.schema.literal(_common.gapStatus.FILLED)]))),
  // Derived, per-rule status filter computed from the aggregated gap duration
  // sums with precedence: unfilled > in_progress > filled.
  highestPriorityGapFillStatuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.gapFillStatus.UNFILLED), _configSchema.schema.literal(_common.gapFillStatus.IN_PROGRESS), _configSchema.schema.literal(_common.gapFillStatus.FILLED)]))),
  hasUnfilledIntervals: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  hasInProgressIntervals: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  hasFilledIntervals: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  ruleTypes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  }))),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  maxRulesToFetch: _configSchema.schema.maybe(_configSchema.schema.number()),
  ruleIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const getRuleIdsWithGapsResponseSchema = exports.getRuleIdsWithGapsResponseSchema = _configSchema.schema.object({
  total: _configSchema.schema.number(),
  ruleIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  latestGapTimestamp: _configSchema.schema.maybe(_configSchema.schema.number())
});