"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rule = exports.existingFlattenedRecoveredAlert = exports.existingFlattenedNewAlert = exports.existingFlattenedActiveAlert = exports.existingExpandedRecoveredAlert = exports.existingExpandedNewAlert = exports.existingExpandedActiveAlert = exports.alertRule = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _format_alert = require("./format_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rule = exports.rule = {
  category: 'My test rule',
  consumer: 'bar',
  execution: {
    uuid: '5f6aa57d-3e22-484e-bae8-cbed868f4d28'
  },
  name: 'rule-name',
  parameters: {
    bar: true
  },
  producer: 'alerts',
  revision: 0,
  rule_type_id: 'test.rule-type',
  tags: ['rule-', '-tags'],
  uuid: '1'
};
const alertRule = exports.alertRule = {
  [_ruleDataUtils.ALERT_RULE_CATEGORY]: rule.category,
  [_ruleDataUtils.ALERT_RULE_CONSUMER]: rule.consumer,
  [_ruleDataUtils.ALERT_RULE_EXECUTION_UUID]: rule.execution.uuid,
  [_ruleDataUtils.ALERT_RULE_NAME]: rule.name,
  [_ruleDataUtils.ALERT_RULE_PARAMETERS]: rule.parameters,
  [_ruleDataUtils.ALERT_RULE_PRODUCER]: rule.producer,
  [_ruleDataUtils.ALERT_RULE_REVISION]: rule.revision,
  [_ruleDataUtils.ALERT_RULE_TYPE_ID]: rule.rule_type_id,
  [_ruleDataUtils.ALERT_RULE_TAGS]: rule.tags,
  [_ruleDataUtils.ALERT_RULE_UUID]: rule.uuid,
  [_ruleDataUtils.SPACE_IDS]: ['default']
};
const existingFlattenedNewAlert = exports.existingFlattenedNewAlert = {
  ...alertRule,
  [_ruleDataUtils.TIMESTAMP]: '2023-03-28T12:27:28.159Z',
  [_ruleDataUtils.EVENT_ACTION]: 'open',
  [_ruleDataUtils.EVENT_KIND]: 'signal',
  [_ruleDataUtils.ALERT_ACTION_GROUP]: 'error',
  [_ruleDataUtils.ALERT_DURATION]: '0',
  [_ruleDataUtils.ALERT_FLAPPING]: false,
  [_ruleDataUtils.ALERT_MUTED]: false,
  [_ruleDataUtils.ALERT_FLAPPING_HISTORY]: [true],
  [_ruleDataUtils.ALERT_INSTANCE_ID]: 'alert-A',
  [_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS]: [],
  [_ruleDataUtils.ALERT_CONSECUTIVE_MATCHES]: 1,
  [_ruleDataUtils.ALERT_STATUS]: 'active',
  [_ruleDataUtils.ALERT_START]: '2023-03-28T12:27:28.159Z',
  [_ruleDataUtils.ALERT_TIME_RANGE]: {
    gte: '2023-03-28T12:27:28.159Z'
  },
  [_ruleDataUtils.ALERT_UUID]: 'abcdefg',
  [_ruleDataUtils.ALERT_WORKFLOW_STATUS]: 'open',
  [_ruleDataUtils.SPACE_IDS]: ['default'],
  [_ruleDataUtils.VERSION]: '8.8.1',
  [_ruleDataUtils.TAGS]: ['rule-', '-tags']
};
const existingFlattenedActiveAlert = exports.existingFlattenedActiveAlert = {
  ...existingFlattenedNewAlert,
  [_ruleDataUtils.TIMESTAMP]: '2023-03-28T12:28:28.159Z',
  [_ruleDataUtils.EVENT_ACTION]: 'active',
  [_ruleDataUtils.ALERT_ACTION_GROUP]: 'default',
  [_ruleDataUtils.ALERT_DURATION]: '3600',
  [_ruleDataUtils.ALERT_FLAPPING_HISTORY]: [true, false],
  [_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS]: ['maint-x'],
  [_ruleDataUtils.ALERT_CONSECUTIVE_MATCHES]: 2
};
const existingFlattenedRecoveredAlert = exports.existingFlattenedRecoveredAlert = {
  ...existingFlattenedActiveAlert,
  [_ruleDataUtils.TIMESTAMP]: '2023-03-28T12:29:28.159Z',
  [_ruleDataUtils.EVENT_ACTION]: 'close',
  [_ruleDataUtils.ALERT_ACTION_GROUP]: 'recovered',
  [_ruleDataUtils.ALERT_DURATION]: '36000000',
  [_ruleDataUtils.ALERT_END]: '2023-03-30T12:27:28.159Z',
  [_ruleDataUtils.ALERT_TIME_RANGE]: {
    gte: '2023-03-27T12:27:28.159Z',
    lte: '2023-03-30T12:27:28.159Z'
  },
  [_ruleDataUtils.ALERT_FLAPPING_HISTORY]: [true, false, false, true],
  [_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS]: ['maint-x'],
  [_ruleDataUtils.ALERT_CONSECUTIVE_MATCHES]: 0,
  [_ruleDataUtils.ALERT_STATUS]: 'recovered',
  [_ruleDataUtils.ALERT_SEVERITY_IMPROVING]: false
};
const existingExpandedNewAlert = exports.existingExpandedNewAlert = (0, _format_alert.expandFlattenedAlert)(existingFlattenedNewAlert);
const existingExpandedActiveAlert = exports.existingExpandedActiveAlert = (0, _format_alert.expandFlattenedAlert)(existingFlattenedActiveAlert);
const existingExpandedRecoveredAlert = exports.existingExpandedRecoveredAlert = (0, _format_alert.expandFlattenedAlert)(existingFlattenedRecoveredAlert);