"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/maintenance-windows-plugin/common");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_navigation = require("../../../hooks/use_navigation");
var _constants = require("../constants");
var _upcoming_events_popover = require("./upcoming_events_popover");
var _status_filter = require("./status_filter");
var _table_actions_popover = require("./table_actions_popover");
var _use_finish_maintenance_window = require("../../../hooks/use_finish_maintenance_window");
var _use_archive_maintenance_window = require("../../../hooks/use_archive_maintenance_window");
var _use_finish_and_archive_maintenance_window = require("../../../hooks/use_finish_and_archive_maintenance_window");
var _kibana_react = require("../../../utils/kibana_react");
var _use_delete_maintenance_window = require("../../../hooks/use_delete_maintenance_window");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/components/maintenance_windows_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getColumns = ({
  dateFormat
}) => [{
  field: 'title',
  name: i18n.NAME,
  truncateText: true
}, {
  field: 'status',
  name: i18n.TABLE_STATUS,
  'data-test-subj': 'maintenance-windows-column-status',
  render: status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: _constants.STATUS_DISPLAY[status].color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, _constants.STATUS_DISPLAY[status].label);
  },
  sortable: ({
    status
  }) => _constants.STATUS_SORT[status]
}, {
  field: 'eventStartTime',
  name: i18n.TABLE_START_TIME,
  dataType: 'date',
  render: (startDate, item) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, (0, _eui.formatDate)(startDate, dateFormat)), item.events.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_upcoming_events_popover.UpcomingEventsPopover, {
      maintenanceWindowFindResponse: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 15
      }
    })) : null);
  },
  sortable: true
}, {
  field: 'eventEndTime',
  name: i18n.TABLE_END_TIME,
  dataType: 'date',
  render: endDate => (0, _eui.formatDate)(endDate, dateFormat)
}];
const rowProps = item => ({
  className: item.status,
  'data-test-subj': 'list-item'
});
const MaintenanceWindowsList = exports.MaintenanceWindowsList = /*#__PURE__*/_react.default.memo(({
  isLoading,
  items,
  readOnly,
  refreshData,
  page,
  perPage,
  total,
  onPageChange,
  selectedStatus,
  onStatusChange,
  onSearchChange
}) => {
  const [search, setSearch] = (0, _react.useState)('');
  const systemDateFormat = (0, _kibana_react.useUiSetting)(_common.UI_SETTINGS.DATE_FORMAT, _common2.MAINTENANCE_WINDOW_DATE_FORMAT);
  const {
    navigateToEditMaintenanceWindows
  } = (0, _use_navigation.useEditMaintenanceWindowsNavigation)();
  const onEdit = (0, _react.useCallback)(id => navigateToEditMaintenanceWindows(id), [navigateToEditMaintenanceWindows]);
  const {
    mutate: finishMaintenanceWindow,
    isLoading: isLoadingFinish
  } = (0, _use_finish_maintenance_window.useFinishMaintenanceWindow)();
  const onCancel = (0, _react.useCallback)(id => finishMaintenanceWindow(id, {
    onSuccess: () => refreshData()
  }), [finishMaintenanceWindow, refreshData]);
  const {
    mutate: archiveMaintenanceWindow,
    isLoading: isLoadingArchive
  } = (0, _use_archive_maintenance_window.useArchiveMaintenanceWindow)();
  const onArchive = (0, _react.useCallback)((id, archive) => archiveMaintenanceWindow({
    maintenanceWindowId: id,
    archive
  }, {
    onSuccess: () => refreshData()
  }), [archiveMaintenanceWindow, refreshData]);
  const {
    mutate: finishAndArchiveMaintenanceWindow,
    isLoading: isLoadingFinishAndArchive
  } = (0, _use_finish_and_archive_maintenance_window.useFinishAndArchiveMaintenanceWindow)();
  const onCancelAndArchive = (0, _react.useCallback)(id => finishAndArchiveMaintenanceWindow(id, {
    onSuccess: () => refreshData()
  }), [finishAndArchiveMaintenanceWindow, refreshData]);
  const {
    mutate: deleteMaintenanceWindow,
    isLoading: isLoadingDelete
  } = (0, _use_delete_maintenance_window.useDeleteMaintenanceWindow)();
  const onDelete = (0, _react.useCallback)(id => deleteMaintenanceWindow({
    maintenanceWindowId: id
  }, {
    onSuccess: () => refreshData()
  }), [deleteMaintenanceWindow, refreshData]);
  const isMutatingOrLoading = (0, _react.useMemo)(() => {
    return isLoadingFinish || isLoadingArchive || isLoadingFinishAndArchive || isLoadingDelete || isLoading;
  }, [isLoadingFinish, isLoadingArchive, isLoadingFinishAndArchive, isLoadingDelete, isLoading]);
  const actions = (0, _react.useMemo)(() => [{
    name: '',
    render: item => {
      return /*#__PURE__*/_react.default.createElement(_table_actions_popover.TableActionsPopover, {
        id: item.id,
        isLoading: isMutatingOrLoading,
        status: item.status,
        onEdit: onEdit,
        onCancel: onCancel,
        onArchive: onArchive,
        onCancelAndArchive: onCancelAndArchive,
        onDelete: onDelete,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 15
        }
      });
    }
  }], [isMutatingOrLoading, onArchive, onCancel, onCancelAndArchive, onDelete, onEdit]);
  const columns = (0, _react.useMemo)(() => {
    const result = getColumns({
      dateFormat: systemDateFormat
    });
    return readOnly ? result : result.concat(actions);
  }, [actions, readOnly, systemDateFormat]);
  const onInputChange = (0, _react.useCallback)(e => {
    setSearch(e.target.value);
    if (e.target.value === '') {
      onSearchChange(e.target.value);
    }
  }, [onSearchChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "maintenance-window-search",
    fullWidth: true,
    isClearable: true,
    incremental: false,
    placeholder: i18n.SEARCH_PLACEHOLDER,
    value: search,
    onChange: onInputChange,
    onSearch: onSearchChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_status_filter.StatusFilter, {
    selectedStatus: selectedStatus,
    onChange: onStatusChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "refresh-button",
    iconType: "refresh",
    onClick: refreshData,
    isLoading: isMutatingOrLoading,
    isDisabled: isMutatingOrLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }, i18n.REFRESH))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "maintenance-windows-table",
    itemId: "id",
    loading: isMutatingOrLoading,
    tableCaption: "Maintenance Windows List",
    items: items,
    columns: columns,
    pagination: {
      pageIndex: page - 1,
      pageSize: perPage,
      pageSizeOptions: [10, 25, 50],
      totalItemCount: total
    },
    rowProps: rowProps,
    onChange: onPageChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  })))));
});
MaintenanceWindowsList.displayName = 'MaintenanceWindowsList';