"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateRulesResponseBodySchema = exports.aggregateRulesRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggregateRulesRequestBodySchema = exports.aggregateRulesRequestBodySchema = _configSchema.schema.object({
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  default_search_operator: _configSchema.schema.oneOf([_configSchema.schema.literal('OR'), _configSchema.schema.literal('AND')], {
    defaultValue: 'OR'
  }),
  search_fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  has_reference: _configSchema.schema.maybe(
  // use nullable as maybe is currently broken
  // in config-schema
  _configSchema.schema.nullable(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    id: _configSchema.schema.string()
  }))),
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  rule_type_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  consumers: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const aggregateRulesResponseBodySchema = exports.aggregateRulesResponseBodySchema = _configSchema.schema.object({
  rule_execution_status: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  rule_last_run_outcome: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
  rule_enabled_status: _configSchema.schema.object({
    enabled: _configSchema.schema.number(),
    disabled: _configSchema.schema.number()
  }),
  rule_muted_status: _configSchema.schema.object({
    muted: _configSchema.schema.number(),
    unmuted: _configSchema.schema.number()
  }),
  rule_snoozed_status: _configSchema.schema.object({
    snoozed: _configSchema.schema.number()
  }),
  rule_tags: _configSchema.schema.arrayOf(_configSchema.schema.string())
});