"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = exports.defaultValidateDef = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultValidateDef = exports.defaultValidateDef = {
  config: {
    schema: _zod.z.object({})
  },
  secrets: {
    schema: _zod.z.object({})
  },
  params: {
    schema: _zod.z.object({})
  }
};
const executor = async options => {
  return {
    status: 'ok',
    actionId: options.actionId
  };
};
const getConnectorType = (overrides = {}) => ({
  id: 'my-connector-type',
  name: 'My connector type',
  minimumLicenseRequired: 'basic',
  supportedFeatureIds: ['alerting'],
  validate: defaultValidateDef,
  executor,
  ...overrides
});
exports.getConnectorType = getConnectorType;