"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.execute = execute;
var _uuid = require("uuid");
var _get_action_kibana_privileges = require("../../../../lib/get_action_kibana_privileges");
var _is_preconfigured = require("../../../../lib/is_preconfigured");
var _is_system_action = require("../../../../lib/is_system_action");
var _saved_objects = require("../../../../constants/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function execute(context, connectorExecuteParams) {
  const log = context.logger;
  const {
    actionId,
    params,
    source,
    relatedSavedObjects
  } = connectorExecuteParams;
  let actionTypeId;
  try {
    if ((0, _is_preconfigured.isPreconfigured)(context, actionId) || (0, _is_system_action.isSystemAction)(context, actionId)) {
      const connector = context.inMemoryConnectors.find(inMemoryConnector => inMemoryConnector.id === actionId);
      actionTypeId = connector === null || connector === void 0 ? void 0 : connector.actionTypeId;
    } else {
      const {
        attributes
      } = await context.unsecuredSavedObjectsClient.get(_saved_objects.ACTION_SAVED_OBJECT_TYPE, actionId);
      actionTypeId = attributes.actionTypeId;
    }
  } catch (err) {
    log.debug(`Failed to retrieve actionTypeId for action [${actionId}]`, err);
  }
  const additionalPrivileges = (0, _get_action_kibana_privileges.getActionKibanaPrivileges)(context, actionTypeId, params, source === null || source === void 0 ? void 0 : source.type);
  await context.authorization.ensureAuthorized({
    operation: 'execute',
    additionalPrivileges,
    actionTypeId
  });
  return context.actionExecutor.execute({
    actionId,
    params,
    source,
    request: context.request,
    relatedSavedObjects,
    actionExecutionId: (0, _uuid.v4)(),
    connectorTokenClient: context.connectorTokenClient
  });
}