"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllConnectorsResponseSchema = exports.getAllConnectorTypesResponseSchema = exports.connectorTypeResponseSchema = exports.connectorResponseSchema = exports.connectorExecuteResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorResponseSchema = exports.connectorResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the connector.'
    }
  }),
  name: _configSchema.schema.string({
    meta: {
      description: ' The name of the connector.'
    }
  }),
  config: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  connector_type_id: _configSchema.schema.string({
    meta: {
      description: 'The connector type identifier.'
    }
  }),
  is_missing_secrets: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector is missing secrets.'
    }
  })),
  is_preconfigured: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector is preconfigured. If true, the `config` and `is_missing_secrets` properties are omitted from the response. '
    }
  }),
  is_deprecated: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector is deprecated.'
    }
  }),
  is_system_action: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector is used for system actions.'
    }
  }),
  is_connector_type_deprecated: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector type is deprecated.'
    }
  })
});
const connectorResponseWithReferencesCountSchema = connectorResponseSchema.extends({
  referenced_by_count: _configSchema.schema.number({
    meta: {
      description: 'The number of saved objects that reference the connector. If is_preconfigured is true, this value is not calculated.'
    }
  })
});
const getAllConnectorsResponseSchema = exports.getAllConnectorsResponseSchema = _configSchema.schema.arrayOf(connectorResponseWithReferencesCountSchema);
const connectorTypeResponseSchema = exports.connectorTypeResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the connector.'
    }
  }),
  name: _configSchema.schema.string({
    meta: {
      description: 'The name of the connector type.'
    }
  }),
  enabled: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector is enabled.'
    }
  }),
  enabled_in_config: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector is enabled in the Kibana configuration.'
    }
  }),
  enabled_in_license: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector is enabled through the license.'
    }
  }),
  minimum_license_required: _configSchema.schema.oneOf([_configSchema.schema.literal('basic'), _configSchema.schema.literal('standard'), _configSchema.schema.literal('gold'), _configSchema.schema.literal('platinum'), _configSchema.schema.literal('enterprise'), _configSchema.schema.literal('trial')], {
    meta: {
      description: 'The minimum license required to enable the connector.'
    }
  }),
  supported_feature_ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'The list of supported features'
    }
  }),
  is_system_action_type: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the action is a system action.'
    }
  }),
  sub_feature: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('endpointSecurity')], {
    meta: {
      description: 'Indicates the sub-feature type the connector is grouped under.'
    }
  })),
  is_deprecated: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the connector type is deprecated.'
    }
  }),
  allow_multiple_system_actions: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether multiple instances of the same system action connector can be used in a single rule.'
    }
  })),
  source: _configSchema.schema.oneOf([_configSchema.schema.literal('yml'), _configSchema.schema.literal('spec'), _configSchema.schema.literal('stack')], {
    meta: {
      description: 'The source of the connector type definition.'
    }
  })
});
const getAllConnectorTypesResponseSchema = exports.getAllConnectorTypesResponseSchema = _configSchema.schema.arrayOf(connectorTypeResponseSchema);
const connectorExecuteResponseSchema = exports.connectorExecuteResponseSchema = _configSchema.schema.object({
  connector_id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the connector.'
    }
  }),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal('ok'), _configSchema.schema.literal('error')], {
    meta: {
      description: 'The outcome of the connector execution.'
    }
  }),
  message: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The connector execution error message.'
    }
  })),
  service_message: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An error message that contains additional details.'
    }
  })),
  data: _configSchema.schema.maybe(_configSchema.schema.any({
    meta: {
      description: 'The connector execution data.'
    }
  })),
  retry: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.boolean(), _configSchema.schema.string()], {
    meta: {
      description: 'When the status is error, identifies whether the connector execution will be retried.'
    }
  }))),
  errorSource: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('user'), _configSchema.schema.literal('framework')], {
    meta: {
      description: 'When the status is error, identifies whether the error is a framework error or a user error.'
    }
  }))
});