"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectable = injectable;
const reflect_metadata_utils_1 = require("@inversifyjs/reflect-metadata-utils");
const classMetadataReflectKey_1 = require("../../reflectMetadata/data/classMetadataReflectKey");
const setIsInjectableFlag_1 = require("../actions/setIsInjectableFlag");
const updateClassMetadataWithTypescriptParameterTypes_1 = require("../actions/updateClassMetadataWithTypescriptParameterTypes");
const getDefaultClassMetadata_1 = require("../calculations/getDefaultClassMetadata");
function injectable(scope) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
    return (target) => {
        (0, setIsInjectableFlag_1.setIsInjectableFlag)(target);
        (0, updateClassMetadataWithTypescriptParameterTypes_1.updateClassMetadataWithTypescriptParameterTypes)(target);
        if (scope !== undefined) {
            (0, reflect_metadata_utils_1.updateOwnReflectMetadata)(target, classMetadataReflectKey_1.classMetadataReflectKey, getDefaultClassMetadata_1.getDefaultClassMetadata, (metadata) => ({
                ...metadata,
                scope,
            }));
        }
    };
}
//# sourceMappingURL=injectable.js.map