"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFlyoutMenuStyles = void 0;
var _react = require("@emotion/react");
var _accessibility = require("../accessibility");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFlyoutMenuStyles = exports.euiFlyoutMenuStyles = function euiFlyoutMenuStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlyoutMenu__container: /*#__PURE__*/(0, _react.css)("block-size:calc(", euiTheme.size.m, " * 3.5);flex-shrink:0;padding-block:", euiTheme.size.s, ";padding-inline:", euiTheme.size.s, ";border-block-end:", euiTheme.border.width.thin, " solid ", euiTheme.border.color, ";padding-block-start:calc(", euiTheme.size.m, " * 0.8);.euiTitle{padding-inline:", euiTheme.size.s, ";};label:euiFlyoutMenu__container;"),
    euiFlyoutMenu__spacer: /*#__PURE__*/(0, _react.css)("padding-inline:", euiTheme.size.m, ";;label:euiFlyoutMenu__spacer;"),
    euiFlyoutMenu__actions: /*#__PURE__*/(0, _react.css)("block-size:calc(", euiTheme.size.m, " * 1.8);;label:euiFlyoutMenu__actions;"),
    euiFlyoutMenu__hiddenTitle: /*#__PURE__*/(0, _react.css)((0, _accessibility.euiScreenReaderOnly)(), ";;label:euiFlyoutMenu__hiddenTitle;")
  };
};