"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFilterButtonWrapperStyles = exports.euiFilterButtonStyles = exports.euiFilterButtonDisplay = exports.euiFilterButtonChildStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _supports = require("../../global_styling/functions/supports");
var _form = require("../form/form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiFilterButtonDisplay = exports.euiFilterButtonDisplay = function euiFilterButtonDisplay(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    flex: '1 1 auto',
    minInlineSize: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 2.75;
    })
  };
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "jkp921-noGrow",
  styles: "flex-grow:0;label:noGrow;"
} : {
  name: "jkp921-noGrow",
  styles: "flex-grow:0;label:noGrow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFilterButtonStyles = exports.euiFilterButtonStyles = function euiFilterButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var selectedSelector = '.euiFilterButton-isSelected';
  var withNextSelector = '& + .euiFilterButton__wrapper';
  return {
    euiFilterButton: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('width', '100%'), " &:not(", selectedSelector, "){&:hover,&:active{.euiFilterButton__notification[class*='subdued']{background-color:", euiTheme.components.filterButtonBadgeBackgroundHover, ";}}};label:euiFilterButton;"),
    buttonType: {
      default: /*#__PURE__*/(0, _react.css)("border-radius:0;&:focus-visible{z-index:1;outline-offset:-", euiTheme.border.width.thick, ";border-radius:", euiTheme.border.radius.small, ";transition:none;};label:default;"),
      toggle: /*#__PURE__*/(0, _react.css)(euiFilterButtonDisplay(euiThemeContext), " &:focus-visible{outline-offset:", (0, _global_styling.mathWithUnits)(euiTheme.focus.width, function (x) {
        return x / 2;
      }), ";}", (0, _global_styling.highContrastModeStyles)(euiThemeContext, {
        forced: "\n            &:is(".concat(selectedSelector, ") {\n              ").concat((0, _global_styling.preventForcedColors)(euiThemeContext), "\n                color: ").concat(euiTheme.colors.emptyShade, ";\n                background-color: ").concat(euiTheme.colors.fullShade, ";\n            }\n          ")
      }), ";;label:toggle;")
    },
    withNext: /*#__PURE__*/(0, _react.css)(withNextSelector, "{", (0, _supports.cssSupportsHasWithNextSibling)("\n            &:has(+ :not(&)) {\n              ".concat((0, _global_styling.logicalCSS)('padding-right', '0'), "\n            }\n          ")), ";", (0, _global_styling.logicalCSS)('margin-left', "-".concat(euiTheme.size.xs)), "&::before{border:none;}};label:withNext;"),
    noGrow: _ref4,
    hasNotification: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 6;
    })), ";;label:hasNotification;"),
    hasActiveFilters: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.medium, ";;label:hasActiveFilters;")
  };
};
var euiFilterButtonWrapperStyles = exports.euiFilterButtonWrapperStyles = function euiFilterButtonWrapperStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    borderColor = _euiFormVariables.borderColor;
  var border = "".concat(euiTheme.border.width.thin, " solid ").concat(borderColor);

  // Pseudo elements create borders without affecting width. We also prefer them
  // over box-shadow for Windows high contrast theme compatibility
  var leftBorder = "\n    &::before {\n      content: '';\n      position: absolute;\n      inset: 0;\n      ".concat((0, _global_styling.logicalCSS)('border-left', border), "\n\n      pointer-events: none;\n    }\n  ");
  // Bottom borders are needed for responsive flex-wrap behavior
  var bottomBorder = "\n    &::after {\n      content: '';\n      position: absolute;\n      inset: 0;\n      ".concat((0, _global_styling.logicalCSS)('border-bottom', border), "\n      pointer-events: none;\n    }\n  ");
  return {
    wrapper: /*#__PURE__*/(0, _react.css)(euiFilterButtonDisplay(euiThemeContext), " position:relative;display:flex;align-items:center;", leftBorder, " ", bottomBorder, " ", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.border.width.thin), ";;label:wrapper;"),
    hasToggle: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.border.width.thin), (0, _supports.cssSupportsHasWithNextSibling)("\n          &:not([class*=\"withNext\"]):has(+ :not(&)) {\n            ".concat((0, _global_styling.logicalCSS)('padding-right', '0'), "\n          }\n        ")), ";;label:hasToggle;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1w3amc7-disabled",
  styles: "opacity:0.5;label:disabled;"
} : {
  name: "1w3amc7-disabled",
  styles: "opacity:0.5;label:disabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "zxesfz-euiFilterButton__notification",
  styles: "cursor:inherit;forced-color-adjust:auto;&{transition:none;};label:euiFilterButton__notification;"
} : {
  name: "zxesfz-euiFilterButton__notification",
  styles: "cursor:inherit;forced-color-adjust:auto;&{transition:none;};label:euiFilterButton__notification;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "kc7mgj-euiFilterButton__content",
  styles: ".euiThemeProvider{display:inline-flex;};label:euiFilterButton__content;"
} : {
  name: "kc7mgj-euiFilterButton__content",
  styles: ".euiThemeProvider{display:inline-flex;};label:euiFilterButton__content;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFilterButtonChildStyles = exports.euiFilterButtonChildStyles = function euiFilterButtonChildStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    content: {
      euiFilterButton__content: _ref3,
      hasIcon: /*#__PURE__*/(0, _react.css)("&>.euiIcon:last-child{", (0, _global_styling.logicalCSS)('margin-left', 'auto'), ";};label:hasIcon;")
    },
    text: {
      euiFilterButton__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextShift)('bold', 'data-text', euiTheme), " ", (0, _global_styling.euiTextTruncate)(), ";;label:euiFilterButton__text;"),
      hasNotification: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x * 2;
      })), ";;label:hasNotification;")
    },
    notification: {
      euiFilterButton__notification: _ref2,
      disabled: _ref
    }
  };
};