"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transparent_background_colors = exports.text_colors = exports.special_colors = exports.shade_colors = exports.light_colors = exports.brand_text_colors = exports.brand_colors = exports.border_colors = exports.background_colors = void 0;
var _primitive_colors = require("./_primitive_colors");
var _semantic_colors = require("./_semantic_colors");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/*
 * LIGHT THEME
 */

var brand_colors = exports.brand_colors = {
  primary: _semantic_colors.SEMANTIC_COLORS.primary90,
  accent: _semantic_colors.SEMANTIC_COLORS.accent90,
  accentSecondary: _semantic_colors.SEMANTIC_COLORS.accentSecondary90,
  success: _semantic_colors.SEMANTIC_COLORS.success90,
  warning: _semantic_colors.SEMANTIC_COLORS.warning40,
  danger: _semantic_colors.SEMANTIC_COLORS.danger90
};
var brand_text_colors = exports.brand_text_colors = {
  /* Legacy colors */
  primaryText: _semantic_colors.SEMANTIC_COLORS.primary100,
  accentText: _semantic_colors.SEMANTIC_COLORS.accent100,
  successText: _semantic_colors.SEMANTIC_COLORS.success100,
  warningText: _semantic_colors.SEMANTIC_COLORS.warning100,
  dangerText: _semantic_colors.SEMANTIC_COLORS.danger100,
  /* New colors */
  textPrimary: _semantic_colors.SEMANTIC_COLORS.primary100,
  textAccent: _semantic_colors.SEMANTIC_COLORS.accent100,
  textAccentSecondary: _semantic_colors.SEMANTIC_COLORS.accentSecondary100,
  textNeutral: _semantic_colors.SEMANTIC_COLORS.neutral100,
  textSuccess: _semantic_colors.SEMANTIC_COLORS.success100,
  textWarning: _semantic_colors.SEMANTIC_COLORS.warning100,
  textRisk: _semantic_colors.SEMANTIC_COLORS.risk100,
  textDanger: _semantic_colors.SEMANTIC_COLORS.danger100
};
var text_colors = exports.text_colors = {
  /* Legacy colors */
  text: _semantic_colors.SEMANTIC_COLORS.shade130,
  title: _semantic_colors.SEMANTIC_COLORS.shade140,
  subduedText: _semantic_colors.SEMANTIC_COLORS.shade95,
  link: _semantic_colors.SEMANTIC_COLORS.primary100,
  /* New colors */
  textParagraph: _semantic_colors.SEMANTIC_COLORS.shade130,
  textHeading: _semantic_colors.SEMANTIC_COLORS.shade140,
  textSubdued: _semantic_colors.SEMANTIC_COLORS.shade95,
  textDisabled: _semantic_colors.SEMANTIC_COLORS.shade70,
  textInverse: _semantic_colors.SEMANTIC_COLORS.plainLight
};
var shade_colors = exports.shade_colors = {
  emptyShade: _semantic_colors.SEMANTIC_COLORS.plainLight,
  lightestShade: _semantic_colors.SEMANTIC_COLORS.shade15,
  lightShade: _semantic_colors.SEMANTIC_COLORS.shade30,
  mediumShade: _semantic_colors.SEMANTIC_COLORS.shade60,
  darkShade: _semantic_colors.SEMANTIC_COLORS.shade90,
  darkestShade: _semantic_colors.SEMANTIC_COLORS.shade120,
  fullShade: _semantic_colors.SEMANTIC_COLORS.plainDark
};
var background_colors = exports.background_colors = {
  backgroundBasePrimary: _semantic_colors.SEMANTIC_COLORS.primary10,
  backgroundBaseAccent: _semantic_colors.SEMANTIC_COLORS.accent10,
  backgroundBaseAccentSecondary: _semantic_colors.SEMANTIC_COLORS.accentSecondary10,
  backgroundBaseNeutral: _semantic_colors.SEMANTIC_COLORS.neutral10,
  backgroundBaseSuccess: _semantic_colors.SEMANTIC_COLORS.success10,
  backgroundBaseWarning: _semantic_colors.SEMANTIC_COLORS.warning10,
  backgroundBaseRisk: _semantic_colors.SEMANTIC_COLORS.risk10,
  backgroundBaseDanger: _semantic_colors.SEMANTIC_COLORS.danger10,
  backgroundBaseSubdued: _semantic_colors.SEMANTIC_COLORS.shade10,
  backgroundBasePlain: _semantic_colors.SEMANTIC_COLORS.plainLight,
  backgroundBaseDisabled: _semantic_colors.SEMANTIC_COLORS.shade15,
  backgroundBaseHighlighted: _semantic_colors.SEMANTIC_COLORS.shade10,
  backgroundBaseFormsPrepend: _semantic_colors.SEMANTIC_COLORS.shade15,
  backgroundBaseFormsControlDisabled: _semantic_colors.SEMANTIC_COLORS.shade30,
  backgroundBaseInteractiveHover: _semantic_colors.SEMANTIC_COLORS.primary100Alpha4,
  backgroundBaseInteractiveSelect: _semantic_colors.SEMANTIC_COLORS.primary10,
  backgroundBaseInteractiveSelectHover: _semantic_colors.SEMANTIC_COLORS.primary20,
  backgroundBaseInteractiveOverlay: _semantic_colors.SEMANTIC_COLORS.shade100Alpha70,
  backgroundBaseSkeletonEdge: _semantic_colors.SEMANTIC_COLORS.shade100Alpha16,
  backgroundBaseSkeletonMiddle: _semantic_colors.SEMANTIC_COLORS.shade100Alpha4,
  backgroundLightPrimary: _semantic_colors.SEMANTIC_COLORS.primary20,
  backgroundLightAccent: _semantic_colors.SEMANTIC_COLORS.accent20,
  backgroundLightAccentSecondary: _semantic_colors.SEMANTIC_COLORS.accentSecondary20,
  backgroundLightNeutral: _semantic_colors.SEMANTIC_COLORS.neutral20,
  backgroundLightSuccess: _semantic_colors.SEMANTIC_COLORS.success20,
  backgroundLightWarning: _semantic_colors.SEMANTIC_COLORS.warning20,
  backgroundLightRisk: _semantic_colors.SEMANTIC_COLORS.risk20,
  backgroundLightDanger: _semantic_colors.SEMANTIC_COLORS.danger20,
  backgroundLightText: _semantic_colors.SEMANTIC_COLORS.shade20,
  backgroundFilledPrimary: _semantic_colors.SEMANTIC_COLORS.primary90,
  backgroundFilledAccent: _semantic_colors.SEMANTIC_COLORS.accent90,
  backgroundFilledAccentSecondary: _semantic_colors.SEMANTIC_COLORS.accentSecondary90,
  backgroundFilledNeutral: _semantic_colors.SEMANTIC_COLORS.neutral80,
  backgroundFilledSuccess: _semantic_colors.SEMANTIC_COLORS.success90,
  backgroundFilledWarning: _semantic_colors.SEMANTIC_COLORS.warning40,
  backgroundFilledRisk: _semantic_colors.SEMANTIC_COLORS.risk70,
  backgroundFilledDanger: _semantic_colors.SEMANTIC_COLORS.danger90,
  backgroundFilledText: _semantic_colors.SEMANTIC_COLORS.shade90
};

/**
 * NOTE: temp values for migration - these should not be used,
 * use backgroundBase tokens instead
 * TODO: remove once obsolete
 */
var transparent_background_colors = exports.transparent_background_colors = {
  backgroundTransparent: _primitive_colors.PRIMITIVE_COLORS.transparent,
  backgroundTransparentPrimary: background_colors.backgroundBasePrimary,
  backgroundTransparentAccent: background_colors.backgroundBaseAccent,
  backgroundTransparentAccentSecondary: background_colors.backgroundBaseAccentSecondary,
  backgroundTransparentNeutral: background_colors.backgroundBaseNeutral,
  backgroundTransparentSuccess: background_colors.backgroundBaseSuccess,
  backgroundTransparentWarning: background_colors.backgroundBaseWarning,
  backgroundTransparentRisk: background_colors.backgroundBaseRisk,
  backgroundTransparentDanger: background_colors.backgroundBaseDanger,
  backgroundTransparentSubdued: _semantic_colors.SEMANTIC_COLORS.shade15,
  backgroundTransparentHighlighted: _semantic_colors.SEMANTIC_COLORS.shade15,
  backgroundTransparentPlain: _semantic_colors.SEMANTIC_COLORS.shade15
};
var border_colors = exports.border_colors = {
  borderBasePrimary: _semantic_colors.SEMANTIC_COLORS.primary30,
  borderBaseAccent: _semantic_colors.SEMANTIC_COLORS.accent30,
  borderBaseAccentSecondary: _semantic_colors.SEMANTIC_COLORS.accentSecondary30,
  borderBaseNeutral: _semantic_colors.SEMANTIC_COLORS.neutral30,
  borderBaseSuccess: _semantic_colors.SEMANTIC_COLORS.success30,
  borderBaseWarning: _semantic_colors.SEMANTIC_COLORS.warning30,
  borderBaseRisk: _semantic_colors.SEMANTIC_COLORS.risk30,
  borderBaseDanger: _semantic_colors.SEMANTIC_COLORS.danger30,
  borderBasePlain: _semantic_colors.SEMANTIC_COLORS.shade30,
  borderBaseSubdued: _semantic_colors.SEMANTIC_COLORS.shade20,
  borderBaseProminent: _semantic_colors.SEMANTIC_COLORS.shade50,
  borderBaseDisabled: _semantic_colors.SEMANTIC_COLORS.shade30,
  borderBaseFloating: _primitive_colors.PRIMITIVE_COLORS.transparent,
  borderBaseFormsColorSwatch: _semantic_colors.SEMANTIC_COLORS.shade100Alpha24,
  borderInteractiveFormsHoverPlain: _semantic_colors.SEMANTIC_COLORS.shade40,
  borderInteractiveFormsHoverProminent: _semantic_colors.SEMANTIC_COLORS.shade70,
  borderInteractiveFormsHoverDanger: _semantic_colors.SEMANTIC_COLORS.danger80,
  borderStrongPrimary: _semantic_colors.SEMANTIC_COLORS.primary90,
  borderStrongAccent: _semantic_colors.SEMANTIC_COLORS.accent90,
  borderStrongAccentSecondary: _semantic_colors.SEMANTIC_COLORS.accentSecondary90,
  borderStrongNeutral: _semantic_colors.SEMANTIC_COLORS.neutral90,
  borderStrongSuccess: _semantic_colors.SEMANTIC_COLORS.success90,
  borderStrongWarning: _semantic_colors.SEMANTIC_COLORS.warning90,
  borderStrongRisk: _semantic_colors.SEMANTIC_COLORS.risk90,
  borderStrongDanger: _semantic_colors.SEMANTIC_COLORS.danger90,
  borderStrongText: _semantic_colors.SEMANTIC_COLORS.shade90
};
var special_colors = exports.special_colors = {
  body: _semantic_colors.SEMANTIC_COLORS.shade10,
  highlight: _semantic_colors.SEMANTIC_COLORS.primary10,
  disabled: _semantic_colors.SEMANTIC_COLORS.shade20,
  disabledText: _semantic_colors.SEMANTIC_COLORS.shade80,
  shadow: _primitive_colors.PRIMITIVE_COLORS.black
};
var light_colors = exports.light_colors = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, brand_colors), shade_colors), special_colors), brand_text_colors), text_colors), background_colors), transparent_background_colors), border_colors);