"use strict";
/*
 * Copyright Elasticsearch B.V. and contributors
 * SPDX-License-Identifier: Apache-2.0
 */
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = require("../../client");
const commonQueryParams = ['error_trace', 'filter_path', 'human', 'pretty'];
class Shutdown {
    constructor(transport) {
        Object.defineProperty(this, "transport", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, _a, {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.transport = transport;
        this[client_1.kAcceptedParams] = {
            'shutdown.delete_node': {
                path: [
                    'node_id'
                ],
                body: [],
                query: [
                    'master_timeout',
                    'timeout'
                ]
            },
            'shutdown.get_node': {
                path: [
                    'node_id'
                ],
                body: [],
                query: [
                    'master_timeout'
                ]
            },
            'shutdown.put_node': {
                path: [
                    'node_id'
                ],
                body: [
                    'type',
                    'reason',
                    'allocation_delay',
                    'target_node_name'
                ],
                query: [
                    'master_timeout',
                    'timeout'
                ]
            }
        };
    }
    async deleteNode(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['shutdown.delete_node'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        const method = 'DELETE';
        const path = `/_nodes/${encodeURIComponent(params.node_id.toString())}/shutdown`;
        const meta = {
            name: 'shutdown.delete_node',
            pathParts: {
                node_id: params.node_id
            },
            acceptedParams: [
                'node_id',
                'master_timeout',
                'timeout'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async getNode(params, options) {
        const { path: acceptedPath } = this[client_1.kAcceptedParams]['shutdown.get_node'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        params = params !== null && params !== void 0 ? params : {};
        for (const key in params) {
            if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                // @ts-expect-error
                querystring[key] = params[key];
            }
        }
        let method = '';
        let path = '';
        if (params.node_id != null) {
            method = 'GET';
            path = `/_nodes/${encodeURIComponent(params.node_id.toString())}/shutdown`;
        }
        else {
            method = 'GET';
            path = '/_nodes/shutdown';
        }
        const meta = {
            name: 'shutdown.get_node',
            pathParts: {
                node_id: params.node_id
            },
            acceptedParams: [
                'node_id',
                'master_timeout'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
    async putNode(params, options) {
        const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = this[client_1.kAcceptedParams]['shutdown.put_node'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedBody.includes(key)) {
                body = body !== null && body !== void 0 ? body : {};
                // @ts-expect-error
                body[key] = params[key];
            }
            else if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                    // @ts-expect-error
                    querystring[key] = params[key];
                }
                else {
                    body = body !== null && body !== void 0 ? body : {};
                    // @ts-expect-error
                    body[key] = params[key];
                }
            }
        }
        const method = 'PUT';
        const path = `/_nodes/${encodeURIComponent(params.node_id.toString())}/shutdown`;
        const meta = {
            name: 'shutdown.put_node',
            pathParts: {
                node_id: params.node_id
            },
            acceptedParams: [
                'node_id',
                'type',
                'reason',
                'allocation_delay',
                'target_node_name',
                'master_timeout',
                'timeout'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
}
_a = client_1.kAcceptedParams;
exports.default = Shutdown;
//# sourceMappingURL=shutdown.js.map