"use strict";
/*
 * Copyright Elasticsearch B.V. and contributors
 * SPDX-License-Identifier: Apache-2.0
 */
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = require("../../client");
const commonQueryParams = ['error_trace', 'filter_path', 'human', 'pretty'];
class Graph {
    constructor(transport) {
        Object.defineProperty(this, "transport", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, _a, {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.transport = transport;
        this[client_1.kAcceptedParams] = {
            'graph.explore': {
                path: [
                    'index'
                ],
                body: [
                    'connections',
                    'controls',
                    'query',
                    'vertices'
                ],
                query: [
                    'routing',
                    'timeout'
                ]
            }
        };
    }
    async explore(params, options) {
        const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = this[client_1.kAcceptedParams]['graph.explore'];
        const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
        const querystring = userQuery != null ? { ...userQuery } : {};
        let body;
        const userBody = params === null || params === void 0 ? void 0 : params.body;
        if (userBody != null) {
            if (typeof userBody === 'string') {
                body = userBody;
            }
            else {
                body = { ...userBody };
            }
        }
        for (const key in params) {
            if (acceptedBody.includes(key)) {
                body = body !== null && body !== void 0 ? body : {};
                // @ts-expect-error
                body[key] = params[key];
            }
            else if (acceptedPath.includes(key)) {
                continue;
            }
            else if (key !== 'body' && key !== 'querystring') {
                if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                    // @ts-expect-error
                    querystring[key] = params[key];
                }
                else {
                    body = body !== null && body !== void 0 ? body : {};
                    // @ts-expect-error
                    body[key] = params[key];
                }
            }
        }
        const method = body != null ? 'POST' : 'GET';
        const path = `/${encodeURIComponent(params.index.toString())}/_graph/explore`;
        const meta = {
            name: 'graph.explore',
            pathParts: {
                index: params.index
            },
            acceptedParams: [
                'index',
                'connections',
                'controls',
                'query',
                'vertices',
                'routing',
                'timeout'
            ]
        };
        return await this.transport.request({ path, method, querystring, body, meta }, options);
    }
}
_a = client_1.kAcceptedParams;
exports.default = Graph;
//# sourceMappingURL=graph.js.map