import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { StartFlowExecutionRequestFilterSensitiveLog, } from "../models/models_0";
import { de_StartFlowExecutionCommand, se_StartFlowExecutionCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class StartFlowExecutionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockAgentRunTimeService", "StartFlowExecution", {})
    .n("BedrockAgentRuntimeClient", "StartFlowExecutionCommand")
    .f(StartFlowExecutionRequestFilterSensitiveLog, void 0)
    .ser(se_StartFlowExecutionCommand)
    .de(de_StartFlowExecutionCommand)
    .build() {
}
