"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIValue = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _use_sync_timerange_url_param = require("../../common/hooks/search_bar/use_sync_timerange_url_param");
var _value_report_exporter = require("../components/ai_value/value_report_exporter");
var _translations = require("../components/ai_value/translations");
var _use_selector = require("../../common/hooks/use_selector");
var _super_date_picker = require("../../common/components/super_date_picker");
var _ai_value = require("../components/ai_value");
var _constants = require("../../common/store/inputs/constants");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _page_wrapper = require("../../common/components/page_wrapper");
var _containers = require("../../sourcerer/containers");
var _header_page = require("../../common/components/header_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _no_privileges = require("../../common/components/no_privileges");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _page_loader = require("../../common/components/page_loader");
var _store = require("../../common/store");
var _helper_hooks = require("../../helper_hooks");
var _kibana = require("../../common/lib/kibana");
var _use_download_ai_value_report = require("../hooks/use_download_ai_value_report");
var _export_provider = require("../providers/ai_value/export_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/pages/ai_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The dashboard includes key performance metrics such as:
 * Cost savings (e.g., based on time saved × analyst hourly rate)
 * Analyst time saved (e.g., minutes saved per alert × volume)
 * Total alerts filtered vs escalated
 * Real attacks detected by AI
 * Alert response time trends
 *
 * Metrics are calculated using dynamic values from the user’s actual data and can be customized per deployment.
 * Visualizations are executive-friendly: concise, interactive, and exportable.
 * Time range selection and historical trend views are supported.
 * Data sources and calculation methods are transparent and documented for auditability.
 */

const BaseComponent = () => {
  const exportContext = (0, _export_provider.useAIValueExportContext)();
  const isExportMode = (exportContext === null || exportContext === void 0 ? void 0 : exportContext.isExportMode) === true;
  const {
    loading: oldIsSourcererLoading
  } = (0, _containers.useSourcererDataView)();
  const timerange = (0, _use_selector.useDeepEqualSelector)(_store.inputsSelectors.valueReportTimeRangeSelector);
  const {
    from,
    to
  } = timerange;
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    status
  } = (0, _use_data_view.useDataView)();
  const isSourcererLoading = newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading;
  const hasSocManagementCapability = (0, _helper_hooks.useHasSecurityCapability)('socManagement');
  const [hasAttackDiscoveries, setHasAttackDiscoveries] = (0, _react.useState)(false);
  const exportPDFRef = (0, _react.useRef)(null);
  const {
    serverless
  } = (0, _kibana.useKibana)().services;
  const isServerless = !!serverless;
  const [exportButtonElement, setExportButtonElement] = (0, _react.useState)(null);

  // since we do not have a search bar in the AI Value page, we need to sync the timerange
  (0, _use_sync_timerange_url_param.useSyncTimerangeUrlParam)();
  const {
    toggleContextMenu,
    isExportEnabled
  } = (0, _use_download_ai_value_report.useDownloadAIValueReport)({
    anchorElement: exportButtonElement,
    timeRange: timerange
  });
  const exportButton = (0, _react.useMemo)(() => isServerless ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "exportPdfButton",
    iconType: "export",
    onClick: () => {
      var _exportPDFRef$current;
      return (_exportPDFRef$current = exportPDFRef.current) === null || _exportPDFRef$current === void 0 ? void 0 : _exportPDFRef$current.call(exportPDFRef);
    },
    size: "s",
    "aria-label": _translations.EXPORT_REPORT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, _translations.EXPORT_REPORT) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "exportPdfButton",
    iconType: "export",
    buttonRef: setExportButtonElement,
    size: "s",
    "aria-label": _translations.EXPORT_REPORT,
    onClick: toggleContextMenu,
    isLoading: !isExportEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, _translations.EXPORT_REPORT), [isServerless, isExportEnabled, toggleContextMenu]);
  if (!hasSocManagementCapability) {
    return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
      docLinkSelector: docLinks => docLinks.siem.privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 12
      }
    });
  }
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "aiValuePage",
    className: (0, _css.css)`
        max-width: 1440px;
        margin: 0 auto;
      `,
    "data-shared-items-container": true
    // This indicate the number of elements that the export logic should wait for before taking a screenshot of the page
    // 6 lens components and 1 AI generated key insight
    ,
    "data-shared-items-count": "7",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, !isExportMode && /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.AI_VALUE_DASHBOARD,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_super_date_picker.SuperDatePicker, {
      id: _constants.InputsModelId.valueReport,
      showUpdateButton: "iconOnly",
      width: "auto",
      compressed: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 13
      }
    }), ...(hasAttackDiscoveries ? [exportButton] : [])],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "aiValueLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "aiValueSections",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_value_report_exporter.ValueReportExporter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, exportPDF => {
    // Store the export function in the ref
    exportPDFRef.current = exportPDF;
    return /*#__PURE__*/_react.default.createElement(_ai_value.AIValueMetrics, {
      from: from,
      to: to,
      setHasAttackDiscoveries: setHasAttackDiscoveries,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 19
      }
    });
  }))));
};
const AIValueComponent = () => /*#__PURE__*/_react.default.createElement(_export_provider.AIValueExportProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 170,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(BaseComponent, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 171,
    columnNumber: 5
  }
}));
const AIValue = exports.AIValue = /*#__PURE__*/_react.default.memo(AIValueComponent);