"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aiValueLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("../../common/constants");
var _translations = require("../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aiValueLinks = exports.aiValueLinks = {
  id: _constants2.SecurityPageName.aiValue,
  title: _translations.AI_VALUE_DASHBOARD,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.aiValueDescription', {
    defaultMessage: 'See ROI for Security AI features'
  }),
  path: _constants2.AI_VALUE_PATH,
  licenseType: 'enterprise',
  capabilities: [[_constants.SECURITY_UI_SHOW_PRIVILEGE, `${_constants2.ATTACK_DISCOVERY_FEATURE_ID}.attack-discovery`, `${_constants2.SECURITY_FEATURE_ID}.socManagement`]],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.aiValue', {
    defaultMessage: 'AI Value'
  }), _i18n.i18n.translate('xpack.securitySolution.appLinks.valueReport', {
    defaultMessage: 'Value report'
  })],
  globalNavPosition: 12,
  hideTimeline: true
};