"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValueMetrics = void 0;
var _react = require("react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _utils = require("../components/ai_value/utils");
var _use_alert_count_query = require("./use_alert_count_query");
var _metrics = require("../components/ai_value/metrics");
var _kibana = require("../../common/lib/kibana");
var _use_find_attack_discoveries = require("../../attack_discovery/pages/use_find_attack_discoveries");
var _constants = require("../../detections/containers/detection_engine/alerts/constants");
var _translations = require("../../attack_discovery/pages/results/history/search_and_filter/translations");
var _get_time_range = require("../../common/utils/get_time_range");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useValueMetrics = ({
  analystHourlyRate,
  from,
  to,
  minutesPerAlert
}) => {
  var _data$unique_alert_id2;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    assistantAvailability
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    data,
    isLoading: isLoadingAttackDiscoveries
  } = (0, _use_find_attack_discoveries.useFindAttackDiscoveries)({
    end: to,
    http,
    includeUniqueAlertIds: true,
    isAssistantEnabled: assistantAvailability.isAssistantEnabled,
    start: from,
    status: [_translations.OPEN, _translations.ACKNOWLEDGED, _translations.CLOSED].map(s => s.toLowerCase())
  });
  const compareTimeRange = (0, _react.useMemo)(() => (0, _get_time_range.getPreviousTimeRange)({
    from,
    to
  }), [from, to]);
  const {
    data: compareAdData,
    isLoading: isLoadingAttackDiscoveriesCompare
  } = (0, _use_find_attack_discoveries.useFindAttackDiscoveries)({
    end: compareTimeRange.to,
    http,
    includeUniqueAlertIds: true,
    isAssistantEnabled: assistantAvailability.isAssistantEnabled,
    start: compareTimeRange.from,
    status: [_translations.OPEN, _translations.ACKNOWLEDGED, _translations.CLOSED].map(s => s.toLowerCase())
  });
  const filters = (0, _react.useMemo)(() => {
    var _data$unique_alert_id;
    return (0, _utils.getExcludeAlertsFilters)((_data$unique_alert_id = data === null || data === void 0 ? void 0 : data.unique_alert_ids) !== null && _data$unique_alert_id !== void 0 ? _data$unique_alert_id : []);
  }, [data === null || data === void 0 ? void 0 : data.unique_alert_ids]);
  const filtersCompare = (0, _react.useMemo)(() => {
    var _compareAdData$unique;
    return (0, _utils.getExcludeAlertsFilters)((_compareAdData$unique = compareAdData === null || compareAdData === void 0 ? void 0 : compareAdData.unique_alert_ids) !== null && _compareAdData$unique !== void 0 ? _compareAdData$unique : []);
  }, [compareAdData === null || compareAdData === void 0 ? void 0 : compareAdData.unique_alert_ids]);
  const {
    alertCount: filteredAlertsCount
  } = (0, _use_alert_count_query.useAlertCountQuery)({
    to,
    from,
    signalIndexName,
    filters,
    queryName: _constants.ALERTS_QUERY_NAMES.COUNT_AI_VALUE
  });
  const {
    alertCount: filteredAlertsCountCompare
  } = (0, _use_alert_count_query.useAlertCountQuery)({
    to: compareTimeRange.to,
    from: compareTimeRange.from,
    signalIndexName,
    filters: filtersCompare,
    queryName: _constants.ALERTS_QUERY_NAMES.COUNT_AI_VALUE_COMPARE
  });
  const {
    alertCount,
    isLoading: isLoadingAlerts
  } = (0, _use_alert_count_query.useAlertCountQuery)({
    to,
    from,
    signalIndexName,
    queryName: _constants.ALERTS_QUERY_NAMES.COUNT_AI_VALUE_TOTAL
  });
  const {
    alertCount: alertCountCompare,
    isLoading: isLoadingAlertsCompare
  } = (0, _use_alert_count_query.useAlertCountQuery)({
    to: compareTimeRange.to,
    from: compareTimeRange.from,
    signalIndexName,
    queryName: _constants.ALERTS_QUERY_NAMES.COUNT_AI_VALUE_TOTAL_COMPARE
  });
  const isLoading = (0, _react.useMemo)(() => isLoadingAlerts || isLoadingAlertsCompare || isLoadingAttackDiscoveriesCompare || isLoadingAttackDiscoveries, [isLoadingAlerts, isLoadingAlertsCompare, isLoadingAttackDiscoveries, isLoadingAttackDiscoveriesCompare]);
  const valueMetrics = (0, _react.useMemo)(() => {
    var _data$total, _ref;
    return (0, _metrics.getValueMetrics)({
      analystHourlyRate,
      attackDiscoveryCount: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0,
      totalAlerts: alertCount,
      // @ts-expect-error upgrade typescript v5.9.3
      escalatedAlertsCount: (_ref = alertCount - filteredAlertsCount) !== null && _ref !== void 0 ? _ref : 0,
      minutesPerAlert
    });
  }, [analystHourlyRate, data === null || data === void 0 ? void 0 : data.total, alertCount, filteredAlertsCount, minutesPerAlert]);
  const valueMetricsCompare = (0, _react.useMemo)(() => {
    var _compareAdData$total, _ref2;
    return (0, _metrics.getValueMetrics)({
      analystHourlyRate,
      attackDiscoveryCount: (_compareAdData$total = compareAdData === null || compareAdData === void 0 ? void 0 : compareAdData.total) !== null && _compareAdData$total !== void 0 ? _compareAdData$total : 0,
      totalAlerts: alertCountCompare,
      // @ts-expect-error upgrade typescript v5.9.3
      escalatedAlertsCount: (_ref2 = alertCountCompare - filteredAlertsCountCompare) !== null && _ref2 !== void 0 ? _ref2 : 0,
      minutesPerAlert
    });
  }, [alertCountCompare, analystHourlyRate, compareAdData === null || compareAdData === void 0 ? void 0 : compareAdData.total, filteredAlertsCountCompare, minutesPerAlert]);
  return {
    attackAlertIds: (_data$unique_alert_id2 = data === null || data === void 0 ? void 0 : data.unique_alert_ids) !== null && _data$unique_alert_id2 !== void 0 ? _data$unique_alert_id2 : [],
    isLoading,
    valueMetrics,
    valueMetricsCompare
  };
};
exports.useValueMetrics = useValueMetrics;