"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDownloadAIValueReport = void 0;
var _i18n = require("@kbn/i18n");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
var _export_provider = require("../providers/ai_value/export_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDownloadAIValueReport = ({
  anchorElement,
  timeRange
}) => {
  const {
    share: shareService,
    serverless,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const isServerless = !!serverless;
  const aiValueExportContext = (0, _export_provider.useAIValueExportContext)();
  const buildForwardedState = aiValueExportContext === null || aiValueExportContext === void 0 ? void 0 : aiValueExportContext.buildForwardedState;
  const forwardedTimeRange = (0, _react.useMemo)(() => {
    if (timeRange.kind === 'relative') {
      return {
        kind: 'relative',
        fromStr: timeRange.fromStr,
        toStr: timeRange.toStr
      };
    }
    return {
      kind: 'absolute',
      from: timeRange.from,
      to: timeRange.to
    };
  }, [timeRange]);
  const forwardedState = (0, _react.useMemo)(() => {
    if (!buildForwardedState) {
      return undefined;
    }
    return buildForwardedState({
      timeRange: forwardedTimeRange
    });
  }, [forwardedTimeRange, buildForwardedState]);
  const isExportEnabled = forwardedState !== undefined &&
  // exporting the report via the share service is only available in ESS
  !isServerless && anchorElement !== null && shareService !== undefined;
  const toggleContextMenu = (0, _react.useMemo)(() => {
    if (!isExportEnabled) {
      return () => {};
    }
    return () => {
      var _uiSettings$get;
      const reportTitle = (_uiSettings$get = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_managementSettingsIds.SECURITY_SOLUTION_DEFAULT_VALUE_REPORT_TITLE)) !== null && _uiSettings$get !== void 0 ? _uiSettings$get : _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.pdfReportJobTitle', {
        defaultMessage: 'AI Value Report'
      });
      shareService.toggleShareContextMenu({
        isDirty: false,
        anchorElement,
        allowShortUrl: false,
        asExport: true,
        objectType: 'ai_value_report',
        objectTypeMeta: {
          title: _i18n.i18n.translate('xpack.securitySolution.reports.aiValue.shareModal.title', {
            defaultMessage: 'Download this report'
          }),
          config: {
            integration: {
              export: {
                pdfReports: {}
              }
            }
          }
        },
        sharingData: {
          title: reportTitle,
          locatorParams: {
            id: _deeplinksAnalytics.AI_VALUE_REPORT_LOCATOR,
            params: forwardedState
          }
        }
      });
    };
  }, [anchorElement, shareService, forwardedState, isExportEnabled, uiSettings]);
  return {
    toggleContextMenu,
    isExportEnabled
  };
};
exports.useDownloadAIValueReport = useDownloadAIValueReport;