"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPercentInfo = exports.getExcludeAlertsFilters = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../overview/components/detection_response/soc_trends/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPercentInfo = ({
  colors,
  colorFamily = 'default',
  currentCount,
  previousCount,
  stat,
  statType
}) => {
  var _getPercChange;
  const percentageChange = (_getPercChange = (0, _helpers.getPercChange)(currentCount, previousCount)) !== null && _getPercChange !== void 0 ? _getPercChange : '0.0%';
  const isNegative = percentageChange.charAt(0) === '-';
  const isZero = percentageChange === '0.0%';
  return {
    percent: isNegative || isZero ? percentageChange : `+${percentageChange}`,
    color: isZero ? 'hollow' : isNegative ? colorFamily === 'bright' || !colors ? 'danger' : colors === null || colors === void 0 ? void 0 : colors.backgroundBaseDanger : colorFamily === 'bright' || !colors ? 'success' : colors === null || colors === void 0 ? void 0 : colors.backgroundBaseSuccess,
    note: isZero ? i18n.NO_CHANGE(statType) : i18n.STAT_DIFFERENCE({
      upOrDown: isNegative ? i18n.DOWN : i18n.UP,
      percentageChange: isNegative ? percentageChange.substring(1) : percentageChange,
      stat,
      statType
    })
  };
};
exports.getPercentInfo = getPercentInfo;
const getExcludeAlertsFilters = alertIds => [{
  meta: {
    alias: null,
    negate: false,
    disabled: false
  },
  query: {
    bool: {
      // only query alerts that are not part of an attack discovery
      must_not: alertIds.map(uuid => ({
        match_phrase: {
          'kibana.alert.uuid': uuid
        }
      }))
    }
  }
}];
exports.getExcludeAlertsFilters = getExcludeAlertsFilters;