"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSaved = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _metrics = require("./metrics");
var _compare_percentage = require("./compare_percentage");
var i18n = _interopRequireWildcard(require("./translations"));
var _time_saved_metric = require("./time_saved_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/time_saved.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeSaved = ({
  minutesPerAlert,
  hoursSaved,
  hoursSavedCompare,
  from,
  to
}) => {
  const timerangeAsDays = (0, _react.useMemo)(() => (0, _metrics.getTimeRangeAsDays)({
    from,
    to
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        min-height: 160px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_time_saved_metric.TimeSavedMetric, {
    minutesPerAlert: minutesPerAlert,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_compare_percentage.ComparePercentage, {
    positionForLens: true,
    currentCount: hoursSaved,
    previousCount: hoursSavedCompare,
    stat: (0, _metrics.formatThousands)(hoursSavedCompare),
    statType: i18n.TIME_SAVED_DESC.toLowerCase(),
    timeRange: timerangeAsDays,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
};
exports.TimeSaved = TimeSaved;