"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIValueMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _value_report_settings = require("./value_report_settings");
var _cost_savings_trend = require("./cost_savings_trend");
var _executive_summary = require("./executive_summary");
var _alert_processing = require("./alert_processing");
var _use_value_metrics = require("../../hooks/use_value_metrics");
var _kibana = require("../../../common/lib/kibana");
var _export_provider = require("../../providers/ai_value/export_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AIValueMetrics = props => {
  const {
    setHasAttackDiscoveries
  } = props;
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const exportContext = (0, _export_provider.useAIValueExportContext)();
  const setReportInputForExportContext = exportContext === null || exportContext === void 0 ? void 0 : exportContext.setReportInput;

  // When exporting/scheduling, forwardedState can include relative date-math strings
  // (e.g. now-7d, now). Resolve them to a deterministic absolute range for this run.
  const forceNow = (0, _react.useMemo)(() => new Date(), []);
  const {
    from,
    to
  } = (0, _react.useMemo)(() => {
    if (exportContext !== null && exportContext !== void 0 && exportContext.forwardedState) {
      var _dateMath$parse$toISO, _dateMath$parse, _dateMath$parse$toISO2, _dateMath$parse2;
      const {
        timeRange
      } = exportContext.forwardedState;
      const fromValue = timeRange.kind === 'absolute' ? timeRange.from : timeRange.fromStr;
      const toValue = timeRange.kind === 'absolute' ? timeRange.to : timeRange.toStr;
      return {
        from: (_dateMath$parse$toISO = (_dateMath$parse = _datemath.default.parse(fromValue, {
          forceNow
        })) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.toISOString()) !== null && _dateMath$parse$toISO !== void 0 ? _dateMath$parse$toISO : fromValue,
        to: (_dateMath$parse$toISO2 = (_dateMath$parse2 = _datemath.default.parse(toValue, {
          forceNow,
          roundUp: true
        })) === null || _dateMath$parse2 === void 0 ? void 0 : _dateMath$parse2.toISOString()) !== null && _dateMath$parse$toISO2 !== void 0 ? _dateMath$parse$toISO2 : toValue
      };
    }
    return {
      from: props.from,
      to: props.to
    };
  }, [props.from, props.to, exportContext === null || exportContext === void 0 ? void 0 : exportContext.forwardedState, forceNow]);
  const {
    analystHourlyRate,
    minutesPerAlert
  } = (0, _react.useMemo)(() => ({
    minutesPerAlert: uiSettings.get(_managementSettingsIds.SECURITY_SOLUTION_DEFAULT_VALUE_REPORT_MINUTES),
    analystHourlyRate: uiSettings.get(_managementSettingsIds.SECURITY_SOLUTION_DEFAULT_VALUE_REPORT_RATE)
  }), [uiSettings]);
  const {
    attackAlertIds,
    isLoading,
    valueMetrics,
    valueMetricsCompare
  } = (0, _use_value_metrics.useValueMetrics)({
    from,
    to,
    minutesPerAlert,
    analystHourlyRate
  });
  const hasAttackDiscoveries = (0, _react.useMemo)(() => valueMetrics.attackDiscoveryCount > 0, [valueMetrics.attackDiscoveryCount]);
  (0, _react.useEffect)(() => {
    if (isLoading || !setReportInputForExportContext) {
      return;
    }
    setReportInputForExportContext({
      attackAlertIds,
      valueMetrics,
      valueMetricsCompare,
      analystHourlyRate,
      minutesPerAlert
    });
  }, [isLoading, attackAlertIds, valueMetrics, valueMetricsCompare, analystHourlyRate, minutesPerAlert, setReportInputForExportContext]);
  (0, _react.useEffect)(() => {
    setHasAttackDiscoveries(hasAttackDiscoveries);
  }, [hasAttackDiscoveries, setHasAttackDiscoveries]);
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        background: ${colors.backgroundBaseSubdued};
        width: 100%;
        min-height: 100%;
        border-radius: 8px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_executive_summary.ExecutiveSummary, {
    attackAlertIds: attackAlertIds,
    analystHourlyRate: analystHourlyRate,
    hasAttackDiscoveries: hasAttackDiscoveries,
    minutesPerAlert: minutesPerAlert,
    isLoading: isLoading,
    from: from,
    to: to,
    valueMetrics: valueMetrics,
    valueMetricsCompare: valueMetricsCompare,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          padding: 0 16px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  })), (isLoading || hasAttackDiscoveries) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alert_processing.AlertProcessing, {
    attackAlertIds: attackAlertIds,
    isLoading: isLoading,
    valueMetrics: valueMetrics,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              padding: 0 16px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }))), (isLoading || hasAttackDiscoveries) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cost_savings_trend.CostSavingsTrend, {
    analystHourlyRate: analystHourlyRate,
    minutesPerAlert: minutesPerAlert,
    from: from,
    to: to,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              padding: 0 16px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_value_report_settings.ValueReportSettings, {
    analystHourlyRate: analystHourlyRate,
    minutesPerAlert: minutesPerAlert,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }));
};
exports.AIValueMetrics = AIValueMetrics;