"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CostSavingsMetric = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _constants = require("../../../data_view_manager/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../common/components/visualization_actions/types");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _cost_savings_metric = require("../../../common/components/visualization_actions/lens_attributes/ai/cost_savings_metric");
var _use_metric_animation = require("../../hooks/use_metric_animation");
var _use_signal_index_with_default = require("../../hooks/use_signal_index_with_default");
var _export_provider = require("../../providers/ai_value/export_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/cost_savings_metric.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ID = 'CostSavingsMetricQuery';
const WithMetricAnimation = ({
  children
}) => {
  // Apply animation to the metric value
  (0, _use_metric_animation.useMetricAnimation)({
    animationDurationMs: 1500,
    // Scope to this embeddable to avoid accidentally animating the first metric value on the page
    // (e.g. "Real threats detected"), since `.echMetricText__value` is used by all Lens metric cards.
    selector: '[data-test-subj="cost-savings-metric"] .echMetricText__value'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};

/**
 * Renders a Lens embeddable metric visualization showing estimated cost savings
 * based on the number of AI filtered alerts, minutes saved per alert,
 * and analyst hourly rate for a given time range.
 */

const CostSavingsMetricComponent = ({
  minutesPerAlert,
  analystHourlyRate,
  from,
  to
}) => {
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const exportContext = (0, _export_provider.useAIValueExportContext)();
  const isExportMode = (exportContext === null || exportContext === void 0 ? void 0 : exportContext.isExportMode) === true;
  const signalIndexName = (0, _use_signal_index_with_default.useSignalIndexWithDefault)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const getLensAttributes = (0, _react.useCallback)(args => (0, _cost_savings_metric.getCostSavingsMetricLensAttributes)({
    ...args,
    backgroundColor: colors.backgroundBaseSuccess,
    minutesPerAlert,
    analystHourlyRate,
    signalIndexName
  }), [analystHourlyRate, colors.backgroundBaseSuccess, minutesPerAlert, signalIndexName]);
  const Visualization = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          height: 100%;
          > * {
            height: 100% !important;
          }
          .echMetricText__icon .euiIcon {
            fill: ${colors.success};
          }
          .echMetricText {
            padding: 8px 16px 60px;
          }
          p.echMetricText__value {
            color: ${colors.success};
            font-size: 48px !important;
            padding: 10px 0;
          }
          .euiPanel,
          .embPanel__hoverActions > span {
            background: ${colors.backgroundBaseSuccess};
          }
          .embPanel__hoverActionsAnchor {
            --internalBorderStyle: 1px solid ${colors.success}!important;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "cost-savings-metric",
    getLensAttributes: getLensAttributes,
    timerange: timerange,
    id: `${ID}-metric`,
    inspectTitle: i18n.COST_SAVINGS_TREND,
    scopeId: _constants.PageScope.alerts,
    withActions: [_types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.inspect],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  })), [getLensAttributes, timerange, colors.success, colors.backgroundBaseSuccess]);
  if (isExportMode) {
    return Visualization;
  }
  return /*#__PURE__*/_react.default.createElement(WithMetricAnimation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 10
    }
  }, Visualization);
};
const CostSavingsMetric = exports.CostSavingsMetric = /*#__PURE__*/_react.default.memo(CostSavingsMetricComponent);