"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CostSavingsKeyInsight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _inferenceCommon = require("@kbn/inference-common");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_license = require("../../../common/hooks/use_license");
var _use_assistant_availability = require("../../../assistant/use_assistant_availability");
var _use_find_cost_savings_prompts = require("../../hooks/use_find_cost_savings_prompts");
var _use_default_ai_connector_id = require("../../../common/hooks/use_default_ai_connector_id");
var _export_provider = require("../../providers/ai_value/export_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/cost_savings_key_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CostSavingsKeyInsightLoader = ({
  isLoading,
  lensResponse
}) => {
  const {
    http,
    notifications,
    inference
  } = (0, _kibana.useKibana)().services;
  const [insightResult, setInsightResult] = (0, _react.useState)('');
  const {
    defaultConnectorId
  } = (0, _use_default_ai_connector_id.useDefaultAIConnectorId)();
  const exportContext = (0, _export_provider.useAIValueExportContext)();
  const setInsightForExportContext = exportContext === null || exportContext === void 0 ? void 0 : exportContext.setInsight;
  const hasEnterpriseLicense = _use_license.licenseService.isEnterprise();
  const {
    hasAssistantPrivilege,
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const prompts = (0, _use_find_cost_savings_prompts.useFindCostSavingsPrompts)({
    context: {
      isAssistantEnabled: hasEnterpriseLicense && (isAssistantEnabled !== null && isAssistantEnabled !== void 0 ? isAssistantEnabled : false) && (hasAssistantPrivilege !== null && hasAssistantPrivilege !== void 0 ? hasAssistantPrivilege : false),
      httpFetch: http.fetch,
      toasts: notifications.toasts
    }
  });
  const fetchInsight = (0, _react.useCallback)(async () => {
    if (lensResponse && defaultConnectorId && prompts !== null) {
      try {
        const prompt = getPrompt(JSON.stringify(lensResponse), prompts);
        const result = await inference.chatComplete({
          connectorId: defaultConnectorId,
          messages: [{
            role: _inferenceCommon.MessageRole.User,
            content: prompt
          }]
        });
        setInsightResult(result.content);
      } catch (error) {
        var _ref, _error$body$message, _error$body;
        setInsightResult(`${i18n.INSIGHTS_ERROR} ${(_ref = (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message) !== null && _ref !== void 0 ? _ref : error.toString()}`);
      }
    }
  }, [defaultConnectorId, lensResponse, inference, prompts]);
  (0, _react.useEffect)(() => {
    fetchInsight();
  }, [fetchInsight]);
  (0, _react.useEffect)(() => {
    if (!lensResponse) setInsightResult('');
  }, [lensResponse]);
  (0, _react.useEffect)(() => {
    if (insightResult.length) {
      setInsightForExportContext === null || setInsightForExportContext === void 0 ? void 0 : setInsightForExportContext(insightResult);
    }
  }, [setInsightForExportContext, insightResult]);
  return /*#__PURE__*/_react.default.createElement(CostSavingsKeyInsightView, {
    insight: insightResult,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 10
    }
  });
};
const CostSavingsKeyInsightView = ({
  insight,
  isLoading
}) => {
  const {
    euiTheme: {
      size,
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const [isRenderComplete, setIsRenderComplete] = (0, _react.useState)(false);
  const containerRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (isRenderComplete && containerRef.current) {
      containerRef.current.dispatchEvent(new CustomEvent('renderComplete', {
        bubbles: true
      }));
    }
  }, [isRenderComplete]);
  const handleMarkdownRender = (0, _react.useCallback)(() => {
    setIsRenderComplete(true);
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alertProcessingKeyInsightsContainer",
    css: (0, _react2.css)`
        background: linear-gradient(
          112deg,
          rgba(89, 159, 254, 0.08) 3.58%,
          rgba(240, 78, 152, 0.08) 98.48%
        );
        border-radius: ${size.s};
        padding: ${size.base};
        min-height: 200px;

        .keyInsightMarkdown {
          color: ${colors.textSubdued};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    "data-test-subj": "alertProcessingKeyInsightsGreetingGroup"
    // These props are necessary when rendering the component in export mode.
    // This attribute signals the export logic that it should wait for this element
    ,
    "data-shared-item": true
    // This indicates that it finished loading and therefore it can be exported
    ,
    "data-render-complete": isRenderComplete,
    ref: containerRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "m",
    "data-test-subj": "alertProcessingKeyInsightsLogo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "alertProcessingKeyInsightsGreeting",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  }, i18n.KEY_INSIGHT)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }), insight && !isLoading ? /*#__PURE__*/_react.default.createElement(_public.Markdown, {
    onRender: handleMarkdownRender,
    markdown: insight,
    className: "keyInsightMarkdown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  })));
};
const CostSavingsKeyInsight = props => {
  var _exportContext$forwar;
  const exportContext = (0, _export_provider.useAIValueExportContext)();
  const Loading = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(CostSavingsKeyInsightView, {
    isLoading: true,
    insight: '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 33
    }
  }), []);
  if (props.isLoading) {
    return Loading;
  }
  if (exportContext !== null && exportContext !== void 0 && (_exportContext$forwar = exportContext.forwardedState) !== null && _exportContext$forwar !== void 0 && _exportContext$forwar.insight) {
    const {
      forwardedState: {
        insight
      },
      isInsightVerified,
      shouldRegenerateInsight
    } = exportContext;
    if (!isInsightVerified) {
      return Loading;
    }
    if (shouldRegenerateInsight === false) {
      return /*#__PURE__*/_react.default.createElement(CostSavingsKeyInsightView, {
        isLoading: false,
        insight: insight,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 14
        }
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(CostSavingsKeyInsightLoader, {
    isLoading: false,
    lensResponse: props.lensResponse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 10
    }
  });
};
exports.CostSavingsKeyInsight = CostSavingsKeyInsight;
const getPrompt = (result, prompts) => {
  const prompt = `${prompts.part1}

\`\`\`
${result}
\`\`\`

${prompts.part2}`;
  return prompt;
};