"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertProcessingKeyInsight = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _metrics = require("./metrics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/alert_processing_key_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertProcessingKeyInsight = ({
  isLoading,
  valueMetrics
}) => {
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const filteredPercentage = (0, _metrics.formatPercent)(valueMetrics.filteredAlertsPerc);
  const escalatedPercentage = (0, _metrics.formatPercent)(valueMetrics.escalatedAlertsPerc);
  const filteredCount = (0, _metrics.formatThousands)(valueMetrics.filteredAlerts);
  const escalatedCount = (0, _metrics.formatThousands)(valueMetrics.totalAlerts - valueMetrics.filteredAlerts);
  const isFilteredNone = filteredPercentage === '0.00%';
  const isFilteredAll = filteredPercentage === '100.00%';
  const isEscalatedAll = escalatedPercentage === '100.00%';
  const isEscalatedNone = escalatedPercentage === '0.00%';
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alertProcessingKeyInsightsContainer",
    css: (0, _react2.css)`
        background: linear-gradient(
          112deg,
          rgba(89, 159, 254, 0.08) 3.58%,
          rgba(240, 78, 152, 0.08) 98.48%
        );
        border-radius: ${size.s};
        padding: ${size.base};
        min-height: 200px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    "data-test-subj": "alertProcessingKeyInsightsGreetingGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "m",
    "data-test-subj": "alertProcessingKeyInsightsLogo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "alertProcessingKeyInsightsGreeting",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }, i18n.KEY_INSIGHT)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    size: "s",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
              line-height: 1.6em;
            `,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    css: (0, _react2.css)`
                  margin-bottom: 5px;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  }, i18n.FILTERED_ALERTS_1({
    percentage: filteredPercentage,
    count: filteredCount
  })), isFilteredAll ? i18n.FILTERED_ALERTS_2_NONE : isFilteredNone ? i18n.FILTERED_ALERTS_2_ALL : i18n.FILTERED_ALERTS_2), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 17
    }
  }, (isEscalatedAll ? i18n.ESCALATED_ALERTS_1_ALL : isEscalatedNone ? i18n.ESCALATED_ALERTS_1_NONE : i18n.ESCALATED_ALERTS_1)({
    percentage: escalatedPercentage,
    count: escalatedCount
  })), isEscalatedAll ? i18n.ESCALATED_ALERTS_2_ALL : isEscalatedNone ? i18n.ESCALATED_ALERTS_2_NONE : i18n.ESCALATED_ALERTS_2)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, i18n.MINIMIZE_ALERT_FATIGUE))));
};
exports.AlertProcessingKeyInsight = AlertProcessingKeyInsight;