"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertProcessingDonut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _constants = require("../../../data_view_manager/constants");
var _types = require("../../../common/components/visualization_actions/types");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _alert_processing_donut = require("../../../common/components/visualization_actions/lens_attributes/ai/alert_processing_donut");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/alert_processing_donut_lens.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartSize = 250;
const visualizationIdPrefix = 'aiValueAlertProcessingDonut';
const AlertProcessingDonut = ({
  attackAlertIds,
  from,
  to
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  // Lens embeddables (and our query store) key state by `id`; make it instance-unique to avoid stale/cross-instance rendering.
  const instanceId = (0, _react.useId)();
  const visualizationId = `${visualizationIdPrefix}-${instanceId}`;
  const {
    euiTheme: {
      font
    }
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "donutChart",
    css: (0, _react2.css)`
        // hide filtering actions in the legend
        .echLegendItem__action {
          display: none;
        }
        .donutText {
          text-align: center;
          top: 44% !important;
          max-width: 100% !important;
          .donutTitleLabel {
            font-size: ${font.scale.m}em;
          }
          b {
            font-size: ${font.scale.xl}em;
          }
        }
        .euiPanel,
        .embPanel,
        .echMetric,
        .echChartBackground,
        .embPanel__hoverActions > span {
          background-color: rgb(0, 0, 0, 0) !important;
        }
        .donutChart .euiPanel {
          background-color: rgb(255, 255, 255, 0);
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    getLensAttributes: args => (0, _alert_processing_donut.getAlertProcessingDonutAttributes)({
      ...args,
      attackAlertIds,
      spaceId: spaceId !== null && spaceId !== void 0 ? spaceId : 'default'
    }),
    height: ChartSize,
    width: '100%',
    id: visualizationId,
    isDonut: true,
    donutTitleLabel: _translations.TOTAL_ALERTS_PROCESSED,
    donutTextWrapperClassName: 'donutText',
    scopeId: _constants.PageScope.alerts,
    timerange: {
      from,
      to
    },
    withActions: [_types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.inspect],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
};
exports.AlertProcessingDonut = AlertProcessingDonut;