"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertProcessing = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _alert_processing_key_insight = require("./alert_processing_key_insight");
var _alert_processing_table = require("./alert_processing_table");
var _metrics = require("./metrics");
var i18n = _interopRequireWildcard(require("./translations"));
var _alert_processing_donut_lens = require("./alert_processing_donut_lens");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/alert_processing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertProcessing = ({
  valueMetrics,
  isLoading,
  from,
  to,
  attackAlertIds
}) => {
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const escalatedAlerts = (0, _react.useMemo)(() => valueMetrics.totalAlerts - valueMetrics.filteredAlerts, [valueMetrics.filteredAlerts, valueMetrics.totalAlerts]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding: ${size.base} ${size.xl};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, i18n.ALERT_PROCESSING_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    "data-test-subj": "alertProcessingGroup",
    css: (0, _react2.css)`
          gap: 48px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            min-width: 300px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_processing_donut_lens.AlertProcessingDonut, {
    attackAlertIds: attackAlertIds,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_processing_table.AlertsProcessingTable, {
    isLoading: isLoading,
    filteredAlerts: valueMetrics.filteredAlerts,
    escalatedAlerts: escalatedAlerts,
    filteredAlertsPerc: (0, _metrics.formatPercent)(valueMetrics.filteredAlertsPerc),
    escalatedAlertsPerc: (0, _metrics.formatPercent)(valueMetrics.escalatedAlertsPerc),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_processing_key_insight.AlertProcessingKeyInsight, {
    isLoading: isLoading,
    valueMetrics: valueMetrics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
};
exports.AlertProcessing = AlertProcessing;