"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginContract = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _service = require("@kbn/security-solution-upselling/service");
var _breadcrumbs = require("./common/breadcrumbs");
var _contract_components = require("./contract_components");
var _service2 = require("./onboarding/service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class PluginContract {
  constructor(experimentalFeatures) {
    (0, _defineProperty2.default)(this, "componentsService", void 0);
    (0, _defineProperty2.default)(this, "upsellingService", void 0);
    (0, _defineProperty2.default)(this, "onboardingService", void 0);
    (0, _defineProperty2.default)(this, "solutionNavigationTree$", void 0);
    (0, _defineProperty2.default)(this, "productFeatureKeys$", void 0);
    this.experimentalFeatures = experimentalFeatures;
    this.onboardingService = new _service2.OnboardingService();
    this.componentsService = new _contract_components.ContractComponentsService();
    this.upsellingService = new _service.UpsellingService();
    this.solutionNavigationTree$ = new _rxjs.BehaviorSubject(null); // defaults to classic navigation
    this.productFeatureKeys$ = new _rxjs.BehaviorSubject(null);
  }
  getSetupContract() {
    return {
      resolver: lazyResolver,
      experimentalFeatures: {
        ...this.experimentalFeatures
      },
      setProductFeatureKeys: productFeatureKeys => {
        this.productFeatureKeys$.next(new Set(productFeatureKeys));
      }
    };
  }
  getStartContract(_core) {
    return {
      setComponents: components => {
        this.componentsService.setComponents(components);
      },
      getBreadcrumbsNav$: () => _breadcrumbs.breadcrumbsNav$,
      getUpselling: () => this.upsellingService,
      setSolutionNavigationTree: navigationTree => {
        this.solutionNavigationTree$.next(navigationTree);
      },
      setOnboardingSettings: this.onboardingService.setSettings.bind(this.onboardingService)
    };
  }
  getStartServices() {
    return {
      getComponents$: this.componentsService.getComponents$.bind(this.componentsService),
      upselling: this.upsellingService,
      onboarding: this.onboardingService,
      productFeatureKeys$: this.productFeatureKeys$.asObservable()
    };
  }
}

/**
 * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
 * See https://webpack.js.org/api/module-methods/#magic-comments
 */
exports.PluginContract = PluginContract;
const lazyResolver = async () => {
  const {
    resolverPluginSetup
  } = await Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "resolver" */
  './resolver')));
  return resolverPluginSetup();
};