"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../common/constants");
var _overview = require("./pages/overview");
var _data_quality = require("./pages/data_quality");
var _detection_response = require("./pages/detection_response");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _entity_analytics_dashboard = require("../entity_analytics/pages/entity_analytics_dashboard");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _use_experimental_features = require("../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OverviewRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_overview.StatefulOverview, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 5
  }
}));
const DetectionResponseRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_detection_response.DetectionResponse, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 5
  }
}));
const EntityAnalyticsRoutes = () => {
  const isThreatHuntingEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('entityThreatHuntingEnabled');
  if (isThreatHuntingEnabled) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.ENTITY_ANALYTICS_THREAT_HUNTING_PATH,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_entity_analytics_dashboard.EntityAnalyticsPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
};
const DataQualityRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_data_quality.DataQuality, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 5
  }
}));
const routes = exports.routes = [{
  path: _constants.OVERVIEW_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(OverviewRoutes, _constants.SecurityPageName.overview)
}, {
  path: _constants.DETECTION_RESPONSE_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(DetectionResponseRoutes, _constants.SecurityPageName.detectionAndResponse)
}, {
  path: _constants.ENTITY_ANALYTICS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsRoutes, _constants.SecurityPageName.entityAnalytics)
}, {
  path: _constants.DATA_QUALITY_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(DataQualityRoutes, _constants.SecurityPageName.dataQuality)
}];