"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_EVENTS = exports.VIEW_ALERTS = exports.TOP = exports.RECENT_TIMELINES = exports.NEWS_FEED_TITLE = exports.EVENTS = exports.ELASTIC_COMMON_SCHEMA = exports.DETECTION_RESPONSE_TITLE = exports.DATE_PICKER_TOOLTIP = exports.DATA_QUALITY_TITLE = exports.BETA = exports.ALERT_TREND = exports.ADD_TO_CASE_SUCCESS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_CASE_SUCCESS = exports.ADD_TO_CASE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.addToCaseSuccessToast', {
  defaultMessage: 'Successfully added data quality results to the case'
});
const BETA = exports.BETA = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.betaBadge', {
  defaultMessage: 'Beta'
});
const DATA_QUALITY_TITLE = exports.DATA_QUALITY_TITLE = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.pageTitle', {
  defaultMessage: 'Data Quality'
});
const DATE_PICKER_TOOLTIP = exports.DATE_PICKER_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.datePicker.tooltip', {
  defaultMessage: `Data quality checks are ran on data that was ingested during the Search Boost window. The default window range is 7 days.`
});
const ELASTIC_COMMON_SCHEMA = exports.ELASTIC_COMMON_SCHEMA = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.elasticCommonSchemaReferenceLink', {
  defaultMessage: 'Elastic Common Schema (ECS)'
});
const EVENTS = exports.EVENTS = _i18n.i18n.translate('xpack.securitySolution.overview.eventsTitle', {
  defaultMessage: 'Event count'
});
const NEWS_FEED_TITLE = exports.NEWS_FEED_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.newsFeedSidebarTitle', {
  defaultMessage: 'Security news'
});
const RECENT_TIMELINES = exports.RECENT_TIMELINES = _i18n.i18n.translate('xpack.securitySolution.overview.recentTimelinesSidebarTitle', {
  defaultMessage: 'Recent timelines'
});
const ALERT_TREND = exports.ALERT_TREND = _i18n.i18n.translate('xpack.securitySolution.overview.signalCountTitle', {
  defaultMessage: 'Alert trend'
});
const TOP = fieldName => _i18n.i18n.translate('xpack.securitySolution.overview.topNLabel', {
  values: {
    fieldName
  },
  defaultMessage: `Top {fieldName}`
});
exports.TOP = TOP;
const VIEW_ALERTS = exports.VIEW_ALERTS = _i18n.i18n.translate('xpack.securitySolution.overview.viewAlertsButtonLabel', {
  defaultMessage: 'View alerts'
});
const VIEW_EVENTS = exports.VIEW_EVENTS = _i18n.i18n.translate('xpack.securitySolution.overview.viewEventsButtonLabel', {
  defaultMessage: 'View events'
});
const DETECTION_RESPONSE_TITLE = exports.DETECTION_RESPONSE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.pageTitle', {
  defaultMessage: 'Detection & Response'
});