"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onboardingLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("../../common/constants");
var _translations = require("../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onboardingLinks = exports.onboardingLinks = {
  id: _constants2.SecurityPageName.landing,
  title: _translations.GETTING_STARTED,
  path: _constants2.ONBOARDING_PATH,
  capabilities: [_constants.SECURITY_UI_SHOW_PRIVILEGE, _constants.RULES_UI_READ_PRIVILEGE],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.getStarted', {
    defaultMessage: 'Getting started'
  })],
  sideNavIcon: 'launch',
  sideNavFooter: true,
  skipUrlState: true,
  hideTimeline: true
};