"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onboardingConfig = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("./constants");
var _body_config = require("./components/onboarding_body/body_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onboardingConfig = exports.onboardingConfig = [{
  id: _constants2.OnboardingTopicId.default,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.default', {
    defaultMessage: 'Set up Security'
  }),
  capabilitiesRequired: _constants.RULES_UI_DETECTIONS_PRIVILEGE,
  body: _body_config.defaultBodyConfig
}, {
  // The "detections" and "external_detections" capabilities are mutually exclusive, so we will always have only one `default` topic enabled at a time
  id: _constants2.OnboardingTopicId.default,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.externalDetections.default', {
    defaultMessage: 'Set up Security'
  }),
  capabilitiesRequired: _constants.RULES_UI_EXTERNAL_DETECTIONS_PRIVILEGE,
  body: _body_config.defaultExternalDetectionsBodyConfig
}, {
  id: _constants2.OnboardingTopicId.siemMigrations,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.automaticMigration', {
    defaultMessage: 'Automatic migration'
  }),
  body: _body_config.siemMigrationsBodyConfig,
  disabledExperimentalFlagRequired: 'siemMigrationsDisabled',
  capabilitiesRequired: [[`dashboard_v2.show`], [_constants.RULES_UI_DETECTIONS_PRIVILEGE]]
}];