"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpandedCard = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _onboarding_card_panel = require("../onboarding_card_panel.styles");
var _use_url_detail = require("../../hooks/use_url_detail");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEADER_OFFSET = 40;
const scrollToCard = cardId => {
  setTimeout(() => {
    const element = document.getElementById(cardId);
    if (element) {
      element.focus({
        preventScroll: true
      });
      window.scrollTo({
        top: element.offsetTop - HEADER_OFFSET,
        behavior: 'smooth'
      });
    }
  }, _onboarding_card_panel.HEIGHT_ANIMATION_DURATION);
};

/**
 * This hook manages the expanded card id state in the LocalStorage and the hash in the URL.
 */
const useExpandedCard = () => {
  const {
    setCard
  } = (0, _use_url_detail.useUrlDetail)();
  const {
    hash
  } = (0, _reactRouterDom.useLocation)();
  const cardIdFromHash = (0, _react.useMemo)(() => (0, _use_url_detail.getCardIdFromHash)(hash), [hash]);
  const [expandedCardId, _setExpandedCardId] = (0, _react.useState)(null);

  // This effect implements auto-scroll in the initial render.
  (0, _react.useEffect)(() => {
    if (cardIdFromHash) {
      _setExpandedCardId(cardIdFromHash);
      scrollToCard(cardIdFromHash);
    }
  }, [cardIdFromHash]);
  const setExpandedCardId = (0, _react.useCallback)((newCardId, options) => {
    _setExpandedCardId(newCardId);
    setCard(newCardId);
    if (newCardId != null && options !== null && options !== void 0 && options.scroll) {
      scrollToCard(newCardId);
    }
  }, [setCard]);
  return {
    expandedCardId,
    setExpandedCardId
  };
};
exports.useExpandedCard = useExpandedCard;