"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBodyConfig = void 0;
var _react = require("react");
var _onboarding_context = require("../../onboarding_context");
var _use_topic_id = require("../../hooks/use_topic_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns the body config for the selected topic
 */
const useBodyConfig = () => {
  const topicId = (0, _use_topic_id.useTopicId)();
  const {
    config
  } = (0, _onboarding_context.useOnboardingContext)();
  const topicBodyConfig = (0, _react.useMemo)(() => {
    let bodyConfig = [];
    const topicConfig = config.get(topicId);
    // The selected topic should always exist in the config, but we check just in case
    if (topicConfig) {
      bodyConfig = topicConfig.body;
    }
    return bodyConfig;
  }, [config, topicId]);
  return topicBodyConfig;
};
exports.useBodyConfig = useBodyConfig;