"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KNOWLEDGE_SOURCE_CARD_TITLE = exports.KNOWLEDGE_SOURCE_CARD_STEP_SELECTOR_TITLE = exports.KNOWLEDGE_SOURCE_CARD_DESCRIPTION = exports.KNOWLEDGE_SOURCE_CARD_CHECK_COMPLETE_ERROR_MESSAGE = exports.KNOWLEDGE_SOURCE_CARD_CALLOUT_INTEGRATIONS_TEXT = exports.KNOWLEDGE_SOURCE_CARD_CALLOUT_INTEGRATIONS_BUTTON = exports.KNOWLEDGE_SOURCE_CARD_ADD_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KNOWLEDGE_SOURCE_CARD_TITLE = exports.KNOWLEDGE_SOURCE_CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCard.title', {
  defaultMessage: 'Add knowledge sources'
});
const KNOWLEDGE_SOURCE_CARD_DESCRIPTION = exports.KNOWLEDGE_SOURCE_CARD_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCard.description', {
  defaultMessage: 'Integrate knowledge from third-party sources to use with the AI Assistant during incident response.'
});
const KNOWLEDGE_SOURCE_CARD_CALLOUT_INTEGRATIONS_TEXT = exports.KNOWLEDGE_SOURCE_CARD_CALLOUT_INTEGRATIONS_TEXT = _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCard.calloutIntegrationsText', {
  defaultMessage: 'To add knowledge sources add integrations first.'
});
const KNOWLEDGE_SOURCE_CARD_CALLOUT_INTEGRATIONS_BUTTON = exports.KNOWLEDGE_SOURCE_CARD_CALLOUT_INTEGRATIONS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCard.calloutIntegrationsButton', {
  defaultMessage: 'Add integrations step'
});
const KNOWLEDGE_SOURCE_CARD_ADD_BUTTON = exports.KNOWLEDGE_SOURCE_CARD_ADD_BUTTON = _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCard.addButton', {
  defaultMessage: 'Add knowledge sources'
});
const KNOWLEDGE_SOURCE_CARD_CHECK_COMPLETE_ERROR_MESSAGE = exports.KNOWLEDGE_SOURCE_CARD_CHECK_COMPLETE_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCard.checkCompleteErrorMessage', {
  defaultMessage: 'Failed to check Card knowledge source completion.'
});
const KNOWLEDGE_SOURCE_CARD_STEP_SELECTOR_TITLE = exports.KNOWLEDGE_SOURCE_CARD_STEP_SELECTOR_TITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCard.stepSelectorTitle', {
  defaultMessage: 'More detail on how to use knowledge sources'
});