"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTabs = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _unsaved_changes_confirm_modal = require("./unsaved_changes_confirm_modal");
var _use_license = require("../../../../../common/hooks/use_license");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _protection_updates_layout = require("../protection_updates/protection_updates_layout");
var _policy_settings_layout = require("../policy_settings_layout");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _routing = require("../../../../common/routing");
var _kibana = require("../../../../../common/lib/kibana");
var _management_page_loader = require("../../../../components/management_page_loader");
var _selectors = require("../../store/policy_details/selectors");
var _policy_artifacts_layout = require("../artifacts/layout/policy_artifacts_layout");
var _policy_hooks = require("../policy_hooks");
var _event_filters_translations = require("./event_filters_translations");
var _trusted_apps_translations = require("./trusted_apps_translations");
var _host_isolation_exceptions_translations = require("./host_isolation_exceptions_translations");
var _blocklists_translations = require("./blocklists_translations");
var _api_client = require("../../../trusted_apps/service/api_client");
var _api_client2 = require("../../../event_filters/service/api_client");
var _blocklists_api_client = require("../../../blocklist/services/blocklists_api_client");
var _host_isolation_exceptions_api_client = require("../../../host_isolation_exceptions/host_isolation_exceptions_api_client");
var _constants = require("../../../trusted_apps/constants");
var _constants2 = require("../../../event_filters/constants");
var _constants3 = require("../../../host_isolation_exceptions/constants");
var _constants4 = require("../../../blocklist/constants");
var _constants5 = require("../../../trusted_devices/constants");
var _use_host_isolation_exceptions_access = require("../../../../hooks/artifacts/use_host_isolation_exceptions_access");
var _api_client3 = require("../../../trusted_devices/service/api_client");
var _trusted_devices_translations = require("./trusted_devices_translations");
var _constants6 = require("../../../endpoint_exceptions/constants");
var _api_client4 = require("../../../endpoint_exceptions/service/api_client");
var _endpoint_exceptions_translations = require("./endpoint_exceptions_translations");
var _trusted_apps_list = require("../../../trusted_apps/view/trusted_apps_list");
var _event_filters_list = require("../../../event_filters/view/event_filters_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/tabs/policy_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var PolicyTabKeys = /*#__PURE__*/function (PolicyTabKeys) {
  PolicyTabKeys["SETTINGS"] = "settings";
  PolicyTabKeys["TRUSTED_APPS"] = "trustedApps";
  PolicyTabKeys["EVENT_FILTERS"] = "eventFilters";
  PolicyTabKeys["HOST_ISOLATION_EXCEPTIONS"] = "hostIsolationExceptions";
  PolicyTabKeys["BLOCKLISTS"] = "blocklists";
  PolicyTabKeys["PROTECTION_UPDATES"] = "protectionUpdates";
  PolicyTabKeys["TRUSTED_DEVICES"] = "trustedDevices";
  PolicyTabKeys["ENDPOINT_EXCEPTIONS"] = "endpointExceptions";
  return PolicyTabKeys;
}(PolicyTabKeys || {});
const PolicyTabs = exports.PolicyTabs = /*#__PURE__*/_react2.default.memo(() => {
  const history = (0, _reactRouterDom.useHistory)();
  const http = (0, _kibana.useHttp)();
  const toasts = (0, _kibana.useToasts)();
  const theme = (0, _eui.useEuiTheme)();
  const isInSettingsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnPolicyFormView);
  const isInTrustedAppsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnPolicyTrustedAppsView);
  const isInTrustedDevicesTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnPolicyTrustedDevicesView);
  const isInEventFiltersTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnPolicyEventFiltersView);
  const isInHostIsolationExceptionsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnHostIsolationExceptionsView);
  const isInBlocklistsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnBlocklistsView);
  const isInEndpointExceptionsTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnEndpointExceptionsView);
  const isInProtectionUpdatesTab = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isOnProtectionUpdatesView);
  const policyId = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyIdFromParams);
  const [unsavedChangesModal, setUnsavedChangesModal] = (0, _react2.useState)({
    showModal: false,
    nextTab: null
  });
  const [unsavedChanges, setUnsavedChanges] = (0, _react2.useState)({
    [PolicyTabKeys.SETTINGS]: false,
    [PolicyTabKeys.PROTECTION_UPDATES]: false
  });
  const setTabUnsavedChanges = (0, _react2.useCallback)(tab => hasUnsavedChanges => {
    if (unsavedChanges[tab] !== hasUnsavedChanges) {
      setUnsavedChanges(prev => ({
        ...prev,
        [tab]: hasUnsavedChanges
      }));
    }
  }, [unsavedChanges]);

  // By the time the tabs load, we know that we already have a `policyItem` since a conditional
  // check is done at the `PageDetails` component level. So asserting to non-null/undefined here.
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const policyItem = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyDetails);
  const {
    canReadTrustedApplications,
    canWriteTrustedApplications,
    canReadEventFilters,
    canWriteEventFilters,
    canAccessHostIsolationExceptions,
    canReadHostIsolationExceptions,
    canWriteHostIsolationExceptions,
    canReadBlocklist,
    canWriteBlocklist,
    canReadTrustedDevices,
    canWriteTrustedDevices,
    canReadEndpointExceptions,
    canWriteEndpointExceptions,
    loading: isPrivilegesLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    state: routeState = {}
  } = (0, _reactRouterDom.useLocation)();
  const isTrustedDevicesFeatureEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('trustedDevices');
  const isEndpointExceptionsMovedUnderManagementFeatureEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointExceptionsMovedUnderManagement');
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const isTrustedDevicesEnabled = isEnterprise && isTrustedDevicesFeatureEnabled && canReadTrustedDevices;
  const getHostIsolationExceptionsApiClientInstance = (0, _react2.useCallback)(() => _host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(http), [http]);
  const {
    hasAccessToHostIsolationExceptions,
    isHostIsolationExceptionsAccessLoading
  } = (0, _use_host_isolation_exceptions_access.useHostIsolationExceptionsAccess)(canAccessHostIsolationExceptions, canReadHostIsolationExceptions, getHostIsolationExceptionsApiClientInstance);

  // move the user out of this route if they can't access it
  (0, _react2.useEffect)(() => {
    if (isHostIsolationExceptionsAccessLoading || isPrivilegesLoading) {
      return;
    }
    const redirectHostIsolationException = isInHostIsolationExceptionsTab && (!canReadHostIsolationExceptions || !isHostIsolationExceptionsAccessLoading && !hasAccessToHostIsolationExceptions);
    if (isInTrustedAppsTab && !canReadTrustedApplications || isInEventFiltersTab && !canReadEventFilters || redirectHostIsolationException || isInBlocklistsTab && !canReadBlocklist || isInEndpointExceptionsTab && !canReadEndpointExceptions || isInTrustedDevicesTab && !canReadTrustedDevices) {
      history.replace((0, _routing.getPolicyDetailPath)(policyId));
      toasts.addDanger(_i18n.i18n.translate('xpack.securitySolution.policyDetails.missingArtifactAccess', {
        defaultMessage: 'You do not have the required Kibana permissions to use the given artifact.'
      }));
    }
  }, [canReadBlocklist, canReadEndpointExceptions, canReadEventFilters, canReadHostIsolationExceptions, canReadTrustedApplications, canReadTrustedDevices, hasAccessToHostIsolationExceptions, history, isHostIsolationExceptionsAccessLoading, isInBlocklistsTab, isInEndpointExceptionsTab, isInEventFiltersTab, isInHostIsolationExceptionsTab, isInProtectionUpdatesTab, isInTrustedAppsTab, isInTrustedDevicesTab, isPrivilegesLoading, policyId, toasts]);
  const getTrustedAppsApiClientInstance = (0, _react2.useCallback)(() => _api_client.TrustedAppsApiClient.getInstance(http), [http]);
  const getTrustedDevicesApiClientInstance = (0, _react2.useCallback)(() => _api_client3.TrustedDevicesApiClient.getInstance(http), [http]);
  const getEventFiltersApiClientInstance = (0, _react2.useCallback)(() => _api_client2.EventFiltersApiClient.getInstance(http), [http]);
  const getBlocklistsApiClientInstance = (0, _react2.useCallback)(() => _blocklists_api_client.BlocklistsApiClient.getInstance(http), [http]);
  const getEndpointExceptionsApiClientInstance = (0, _react2.useCallback)(() => _api_client4.EndpointExceptionsApiClient.getInstance(http), [http]);
  const tabs = (0, _react2.useMemo)(() => {
    const trustedAppsLabels = {
      ..._trusted_apps_translations.POLICY_ARTIFACT_TRUSTED_APPS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.trustedApps.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} trusted {count, plural, =1 {application} other {applications}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 253,
          columnNumber: 9
        }
      })
    };
    const trustedDevicesLabels = {
      ..._trusted_devices_translations.POLICY_ARTIFACT_TRUSTED_DEVICES_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.trustedDevices.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} trusted {count, plural, =1 {device} other {devices}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 9
        }
      })
    };
    const eventFiltersLabels = {
      ..._event_filters_translations.POLICY_ARTIFACT_EVENT_FILTERS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.eventFilters.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} event {count, plural, =1 {filter} other {filters}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 9
        }
      })
    };
    const hostIsolationExceptionsLabels = {
      ..._host_isolation_exceptions_translations.POLICY_ARTIFACT_HOST_ISOLATION_EXCEPTIONS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.hostIsolationExceptions.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} host isolation {count, plural, =1 {exception} other {exceptions}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 286,
          columnNumber: 9
        }
      })
    };
    const blocklistsLabels = {
      ..._blocklists_translations.POLICY_ARTIFACT_BLOCKLISTS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.blocklist.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} {count, plural, =1 {blocklist} other {blocklist entries}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 297,
          columnNumber: 9
        }
      })
    };
    const endpointExceptionsLabels = {
      ..._endpoint_exceptions_translations.POLICY_ARTIFACT_ENDPOINT_EXCEPTIONS_LABELS,
      layoutAboutMessage: (count, link) => /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.endpointExceptions.list.about",
        defaultMessage: "There {count, plural, one {is} other {are}} {count} {count, plural, =1 {endpoint exception} other {endpoint exceptions}} associated with this policy. Click here to {link}",
        values: {
          count,
          link
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 9
        }
      })
    };
    return {
      [PolicyTabKeys.SETTINGS]: {
        id: PolicyTabKeys.SETTINGS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.policyForm', {
          defaultMessage: 'Policy settings'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 324,
            columnNumber: 13
          }
        }), /*#__PURE__*/_react2.default.createElement(_policy_settings_layout.PolicySettingsLayout, {
          policy: policyItem,
          setUnsavedChanges: setTabUnsavedChanges(PolicyTabKeys.SETTINGS),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 326,
            columnNumber: 13
          }
        })),
        'data-test-subj': 'policySettingsTab'
      },
      [PolicyTabKeys.TRUSTED_APPS]: canReadTrustedApplications ? {
        id: PolicyTabKeys.TRUSTED_APPS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.trustedApps', {
          defaultMessage: 'Trusted applications'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 345,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react2.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: trustedAppsLabels,
          getExceptionsListApiClient: getTrustedAppsApiClientInstance,
          searchableFields: _constants.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getTrustedAppsListPath,
          getPolicyArtifactsPath: _routing.getPolicyDetailsArtifactsListPath,
          canWriteArtifact: canWriteTrustedApplications,
          CardDecorator: _trusted_apps_list.TrustedAppsCardDecorator,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 346,
            columnNumber: 17
          }
        })),
        'data-test-subj': 'policyTrustedAppsTab'
      } : undefined,
      [PolicyTabKeys.TRUSTED_DEVICES]: isTrustedDevicesEnabled ? {
        id: PolicyTabKeys.TRUSTED_DEVICES,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.trustedDevices', {
          defaultMessage: 'Trusted devices'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 372,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react2.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: trustedDevicesLabels,
          getExceptionsListApiClient: getTrustedDevicesApiClientInstance,
          searchableFields: _constants5.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getTrustedDevicesListPath,
          getPolicyArtifactsPath: _routing.getPolicyTrustedDevicesPath,
          canWriteArtifact: canWriteTrustedDevices,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 373,
            columnNumber: 17
          }
        })),
        'data-test-subj': 'policyTrustedDevicesTab'
      } : undefined,
      [PolicyTabKeys.EVENT_FILTERS]: canReadEventFilters ? {
        id: PolicyTabKeys.EVENT_FILTERS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.eventFilters', {
          defaultMessage: 'Event filters'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 398,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react2.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: eventFiltersLabels,
          getExceptionsListApiClient: getEventFiltersApiClientInstance,
          searchableFields: _constants2.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getEventFiltersListPath,
          getPolicyArtifactsPath: _routing.getPolicyEventFiltersPath,
          canWriteArtifact: canWriteEventFilters,
          CardDecorator: _event_filters_list.EventFiltersCardDecorator,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 399,
            columnNumber: 17
          }
        })),
        'data-test-subj': 'policyEventFiltersTab'
      } : undefined,
      [PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS]: hasAccessToHostIsolationExceptions ? {
        id: PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.isInHostIsolationExceptions', {
          defaultMessage: 'Host isolation exceptions'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 425,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react2.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: hostIsolationExceptionsLabels,
          getExceptionsListApiClient: getHostIsolationExceptionsApiClientInstance,
          searchableFields: _constants3.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getHostIsolationExceptionsListPath,
          getPolicyArtifactsPath: _routing.getPolicyHostIsolationExceptionsPath,
          canWriteArtifact: canWriteHostIsolationExceptions,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 426,
            columnNumber: 17
          }
        })),
        'data-test-subj': 'policyHostIsolationExceptionsTab'
      } : undefined,
      [PolicyTabKeys.BLOCKLISTS]: canReadBlocklist ? {
        id: PolicyTabKeys.BLOCKLISTS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.blocklists', {
          defaultMessage: 'Blocklist'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 448,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react2.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: blocklistsLabels,
          getExceptionsListApiClient: getBlocklistsApiClientInstance,
          searchableFields: _constants4.SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getBlocklistsListPath,
          getPolicyArtifactsPath: _routing.getPolicyBlocklistsPath,
          canWriteArtifact: canWriteBlocklist,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 449,
            columnNumber: 17
          }
        })),
        'data-test-subj': 'policyBlocklistTab'
      } : undefined,
      [PolicyTabKeys.ENDPOINT_EXCEPTIONS]: isEndpointExceptionsMovedUnderManagementFeatureEnabled && canReadEndpointExceptions ? {
        id: PolicyTabKeys.ENDPOINT_EXCEPTIONS,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.endpointExceptions', {
          defaultMessage: 'Endpoint exceptions'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 475,
            columnNumber: 19
          }
        }), /*#__PURE__*/_react2.default.createElement(_policy_artifacts_layout.PolicyArtifactsLayout, {
          policyItem: policyItem,
          labels: endpointExceptionsLabels,
          getExceptionsListApiClient: getEndpointExceptionsApiClientInstance,
          searchableFields: _constants6.ENDPOINT_EXCEPTIONS_SEARCHABLE_FIELDS,
          getArtifactPath: _routing.getEndpointExceptionsListPath,
          getPolicyArtifactsPath: _routing.getPolicyEndpointExceptionsPath,
          canWriteArtifact: canWriteEndpointExceptions,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 476,
            columnNumber: 19
          }
        })),
        'data-test-subj': 'policyEndpointExceptionsTab'
      } : undefined,
      [PolicyTabKeys.PROTECTION_UPDATES]: isEnterprise ? {
        id: PolicyTabKeys.PROTECTION_UPDATES,
        name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.tabs.protectionUpdates', {
          defaultMessage: 'Protection updates'
        }),
        content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 502,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react2.default.createElement(_protection_updates_layout.ProtectionUpdatesLayout, {
          policy: policyItem,
          setUnsavedChanges: setTabUnsavedChanges(PolicyTabKeys.PROTECTION_UPDATES),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 503,
            columnNumber: 17
          }
        })),
        'data-test-subj': 'policyProtectionUpdatesTab'
      } : undefined
    };
  }, [policyItem, setTabUnsavedChanges, canReadTrustedApplications, getTrustedAppsApiClientInstance, canWriteTrustedApplications, isTrustedDevicesEnabled, getTrustedDevicesApiClientInstance, canWriteTrustedDevices, canReadEventFilters, getEventFiltersApiClientInstance, canWriteEventFilters, hasAccessToHostIsolationExceptions, getHostIsolationExceptionsApiClientInstance, canWriteHostIsolationExceptions, canReadBlocklist, getBlocklistsApiClientInstance, canWriteBlocklist, isEndpointExceptionsMovedUnderManagementFeatureEnabled, canReadEndpointExceptions, getEndpointExceptionsApiClientInstance, canWriteEndpointExceptions, isEnterprise]);

  // convert tabs object into an array EuiTabbedContent can understand
  const tabsList = (0, _react2.useMemo)(() => Object.values(tabs).filter(tab => tab !== undefined), [tabs]);
  const currentSelectedTab = (0, _react2.useMemo)(() => {
    const defaultTab = tabs[PolicyTabKeys.SETTINGS];
    let selectedTab;
    if (isInSettingsTab) {
      selectedTab = tabs[PolicyTabKeys.SETTINGS];
    } else if (isInTrustedAppsTab) {
      selectedTab = tabs[PolicyTabKeys.TRUSTED_APPS];
    } else if (isInTrustedDevicesTab) {
      selectedTab = tabs[PolicyTabKeys.TRUSTED_DEVICES];
    } else if (isInEventFiltersTab) {
      selectedTab = tabs[PolicyTabKeys.EVENT_FILTERS];
    } else if (isInHostIsolationExceptionsTab) {
      selectedTab = tabs[PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS];
    } else if (isInBlocklistsTab) {
      selectedTab = tabs[PolicyTabKeys.BLOCKLISTS];
    } else if (isInEndpointExceptionsTab) {
      selectedTab = tabs[PolicyTabKeys.ENDPOINT_EXCEPTIONS];
    } else if (isInProtectionUpdatesTab) {
      selectedTab = tabs[PolicyTabKeys.PROTECTION_UPDATES];
    }
    return selectedTab || defaultTab;
  }, [tabs, isInSettingsTab, isInTrustedAppsTab, isInTrustedDevicesTab, isInEventFiltersTab, isInHostIsolationExceptionsTab, isInBlocklistsTab, isInEndpointExceptionsTab, isInProtectionUpdatesTab]);
  const cancelUnsavedChangesModal = (0, _react2.useCallback)(() => {
    setUnsavedChangesModal({
      showModal: false,
      nextTab: null
    });
  }, [setUnsavedChangesModal]);
  const changeTab = (0, _react2.useCallback)(selectedTab => {
    if (unsavedChangesModal.showModal) {
      cancelUnsavedChangesModal();
    }
    let path = '';
    switch (selectedTab.id) {
      case PolicyTabKeys.SETTINGS:
        path = (0, _routing.getPolicyDetailPath)(policyId);
        break;
      case PolicyTabKeys.TRUSTED_APPS:
        path = (0, _routing.getPolicyTrustedAppsPath)(policyId);
        break;
      case PolicyTabKeys.TRUSTED_DEVICES:
        path = (0, _routing.getPolicyTrustedDevicesPath)(policyId);
        break;
      case PolicyTabKeys.EVENT_FILTERS:
        path = (0, _routing.getPolicyEventFiltersPath)(policyId);
        break;
      case PolicyTabKeys.HOST_ISOLATION_EXCEPTIONS:
        path = (0, _routing.getPolicyHostIsolationExceptionsPath)(policyId);
        break;
      case PolicyTabKeys.BLOCKLISTS:
        path = (0, _routing.getPolicyBlocklistsPath)(policyId);
        break;
      case PolicyTabKeys.ENDPOINT_EXCEPTIONS:
        path = (0, _routing.getPolicyEndpointExceptionsPath)(policyId);
        break;
      case PolicyTabKeys.PROTECTION_UPDATES:
        path = (0, _routing.getPolicyProtectionUpdatesPath)(policyId);
        break;
    }
    history.push(path, routeState !== null && routeState !== void 0 && routeState.backLink ? {
      backLink: routeState.backLink
    } : null);
  }, [cancelUnsavedChangesModal, history, policyId, routeState === null || routeState === void 0 ? void 0 : routeState.backLink, unsavedChangesModal.showModal]);
  const onTabClickHandler = (0, _react2.useCallback)(selectedTab => {
    if (isInSettingsTab && unsavedChanges[PolicyTabKeys.SETTINGS] || isInProtectionUpdatesTab && unsavedChanges[PolicyTabKeys.PROTECTION_UPDATES]) {
      setUnsavedChangesModal({
        showModal: true,
        nextTab: selectedTab
      });
    } else {
      changeTab(selectedTab);
    }
  }, [changeTab, isInProtectionUpdatesTab, isInSettingsTab, unsavedChanges]);
  const confirmUnsavedChangesModal = (0, _react2.useCallback)(() => {
    if (unsavedChangesModal.nextTab) {
      changeTab(unsavedChangesModal.nextTab);
    }
  }, [changeTab, unsavedChangesModal.nextTab]);

  // show loader for privileges validation
  if (isPrivilegesLoading || isHostIsolationExceptionsAccessLoading) {
    return /*#__PURE__*/_react2.default.createElement(_management_page_loader.ManagementPageLoader, {
      "data-test-subj": "privilegesLoading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 648,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, unsavedChangesModal.showModal && /*#__PURE__*/_react2.default.createElement(_unsaved_changes_confirm_modal.UnsavedChangesConfirmModal, {
    onCancel: cancelUnsavedChangesModal,
    onConfirm: confirmUnsavedChangesModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 654,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "policyTabs",
    tabs: tabsList,
    selectedTab: currentSelectedTab,
    size: "l",
    onTabClick: onTabClickHandler,
    css: (0, _react.css)`
          & [role='tablist'] {
            flex-wrap: wrap;
            row-gap: ${theme.euiTheme.size.xs};
            column-gap: ${theme.euiTheme.size.l};
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 659,
      columnNumber: 7
    }
  }));
});
PolicyTabs.displayName = 'PolicyTabs';