"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionUpdatesWarningPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/protection_updates/components/protection_updates_warning_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProtectionUpdatesWarningPanel = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.warningPanel.title', {
    defaultMessage: 'Attention'
  }),
  iconType: "alert",
  "data-test-subj": "protection-updates-warning-callout",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 14,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.endpoint.protectionUpdates.warningPanel.content",
  defaultMessage: "Elastic provides periodic updates to protections artifacts such as the global exception list, malware models, and rule packages to ensure your environment is up to date with latest protections. By default, these artifacts are updated automatically. Disable the automatic updates toggle to manually manage updates to the protections artifacts.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.endpoint.protectionUpdates.warningPanel.content.note",
  defaultMessage: "{note} It is strongly advised to keep automatic updates enabled to ensure the highest level of security for your environment. Proceed with caution if you decide to disable automatic updates.",
  values: {
    note: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.warningPanel.content.note.bold', {
      defaultMessage: 'Note:'
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 5
  }
}));
exports.ProtectionUpdatesWarningPanel = ProtectionUpdatesWarningPanel;