"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyEndpointCount = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../../../../../common/lib/kibana");
var _use_navigate_by_router_event_handler = require("../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _routing = require("../../../../common/routing");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/components/policy_endpoint_count.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Returns a link component that navigates to the endpoint list page filtered by a specific policy
 *
 * @param policyId
 * @param nonLinkCondition: boolean where the returned component is just text and not a link
 *
 */
const PolicyEndpointCount = exports.PolicyEndpointCount = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  nonLinkCondition,
  'data-test-subj': dataTestSubj,
  children,
  ...otherProps
}) => {
  const filterByPolicyQuery = `(language:kuery,query:'united.endpoint.Endpoint.policy.applied.id : "${policyId}"')`;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const {
    toRoutePathWithBackOptions,
    toRouteUrl
  } = (0, _react.useMemo)(() => {
    const endpointListPath = (0, _routing.getEndpointListPath)({
      name: 'endpointList',
      admin_query: filterByPolicyQuery
    });
    const policyListPath = (0, _routing.getPoliciesPath)(search);
    const backLink = {
      navigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }],
      label: _i18n.i18n.translate('xpack.securitySolution.policy.backToPolicyList', {
        defaultMessage: 'Back to policy list'
      }),
      href: getAppUrl({
        path: policyListPath
      })
    };
    return {
      toRoutePathWithBackOptions: {
        pathname: (0, _routing.getEndpointListPath)({
          name: 'endpointList'
        }),
        search: `?admin_query=${filterByPolicyQuery}`,
        state: {
          backLink
        }
      },
      toRouteUrl: getAppUrl({
        path: endpointListPath
      })
    };
  }, [getAppUrl, filterByPolicyQuery, search]);
  const clickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(toRoutePathWithBackOptions);
  if (nonLinkCondition) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": `${dataTestSubj}_nonLink`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, children);
  }
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      href: toRouteUrl,
      "data-test-subj": dataTestSubj,
      onClick: clickHandler
    }, otherProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 5
      }
    }), children)
  );
});
PolicyEndpointCount.displayName = 'PolicyEndpointCount';