"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../common/constants");
var _management_page_loader = require("../../../../../components/management_page_loader");
var _use_url_params = require("../../../../../hooks/use_url_params");
var _user_privileges = require("../../../../../../common/components/user_privileges");
var _policy_hooks = require("../../policy_hooks");
var _artifacts = require("../../../../../hooks/artifacts");
var _empty = require("../empty");
var _list = require("../list");
var _flyout = require("../flyout");
var _translations = require("../translations");
var _delete_modal = require("../delete_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/artifacts/layout/policy_artifacts_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyArtifactsLayout = exports.PolicyArtifactsLayout = /*#__PURE__*/_react.default.memo(({
  policyItem,
  labels: _labels = {},
  getExceptionsListApiClient,
  searchableFields,
  getArtifactPath,
  getPolicyArtifactsPath,
  canWriteArtifact = false,
  CardDecorator
}) => {
  const exceptionsListApiClient = (0, _react.useMemo)(() => getExceptionsListApiClient(), [getExceptionsListApiClient]);
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const navigateCallback = (0, _policy_hooks.usePolicyDetailsArtifactsNavigateCallback)(exceptionsListApiClient.listId);
  const {
    canCreateArtifactsByPolicy
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    urlParams
  } = (0, _use_url_params.useUrlParams)();
  const [exceptionItemToDelete, setExceptionItemToDelete] = (0, _react.useState)();
  const labels = (0, _react.useMemo)(() => {
    return {
      ..._translations.policyArtifactsPageLabels,
      ..._labels
    };
  }, [_labels]);
  const {
    data: allAssigned,
    isLoading: isLoadingAllAssigned
  } = (0, _artifacts.useListArtifact)(exceptionsListApiClient, {
    policies: policyItem ? [policyItem.id, 'all'] : []
  }, searchableFields);
  const {
    data: allArtifacts,
    isLoading: isLoadingAllArtifacts,
    isRefetching: isRefetchingAllArtifacts
  } = (0, _artifacts.useListArtifact)(exceptionsListApiClient, {}, searchableFields, {}, ['allExisting']);
  const handleOnClickAssignButton = (0, _react.useCallback)(() => {
    navigateCallback({
      show: 'list'
    });
  }, [navigateCallback]);
  const handleOnCloseFlyout = (0, _react.useCallback)(() => {
    navigateCallback({
      show: undefined
    });
  }, [navigateCallback]);
  const handleDeleteModalClose = (0, _react.useCallback)(() => {
    setExceptionItemToDelete(undefined);
  }, [setExceptionItemToDelete]);
  const handleOnDeleteActionCallback = (0, _react.useCallback)(item => {
    setExceptionItemToDelete(item);
  }, [setExceptionItemToDelete]);
  const assignToPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "artifacts-assign-button",
    onClick: handleOnClickAssignButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, labels.layoutAssignButtonTitle), [handleOnClickAssignButton, labels.layoutAssignButtonTitle]);
  const aboutInfo = (0, _react.useMemo)(() => {
    const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: getAppUrl({
        appId: _constants.APP_UI_ID,
        path: getArtifactPath()
      }),
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, labels.layoutViewAllLinkMessage);
    return labels.layoutAboutMessage((allAssigned === null || allAssigned === void 0 ? void 0 : allAssigned.total) || 0, link);
  }, [getAppUrl, getArtifactPath, labels, allAssigned === null || allAssigned === void 0 ? void 0 : allAssigned.total]);
  const isGlobalLoading = (0, _react.useMemo)(() => isLoadingAllAssigned || isLoadingAllArtifacts || isRefetchingAllArtifacts, [isLoadingAllAssigned, isLoadingAllArtifacts, isRefetchingAllArtifacts]);
  const isEmptyState = (0, _react.useMemo)(() => allAssigned && allAssigned.total === 0, [allAssigned]);
  if (!policyItem || isGlobalLoading) {
    return /*#__PURE__*/_react.default.createElement(_management_page_loader.ManagementPageLoader, {
      "data-test-subj": "policy-artifacts-loading-spinner",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 14
      }
    });
  }
  if (isEmptyState) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canCreateArtifactsByPolicy && urlParams.show === 'list' && /*#__PURE__*/_react.default.createElement(_flyout.PolicyArtifactsFlyout, {
      policyItem: policyItem,
      apiClient: exceptionsListApiClient,
      searchableFields: [...searchableFields],
      onClose: handleOnCloseFlyout,
      labels: labels,
      CardDecorator: CardDecorator,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }), allArtifacts && allArtifacts.total !== 0 ? /*#__PURE__*/_react.default.createElement(_empty.PolicyArtifactsEmptyUnassigned, {
      policyId: policyItem.id,
      policyName: policyItem.name,
      listId: exceptionsListApiClient.listId,
      labels: labels,
      canWriteArtifact: canWriteArtifact,
      getPolicyArtifactsPath: getPolicyArtifactsPath,
      getArtifactPath: getArtifactPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_empty.PolicyArtifactsEmptyUnexisting, {
      policyId: policyItem.id,
      policyName: policyItem.name,
      labels: labels,
      canWriteArtifact: canWriteArtifact,
      getPolicyArtifactsPath: getPolicyArtifactsPath,
      getArtifactPath: getArtifactPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 13
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    "data-test-subj": "policy-artifacts-header-section",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }, labels.layoutTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "policy-artifacts-layout-about",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  }, aboutInfo))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, canCreateArtifactsByPolicy && canWriteArtifact && assignToPolicyButton)), canCreateArtifactsByPolicy && canWriteArtifact && urlParams.show === 'list' && /*#__PURE__*/_react.default.createElement(_flyout.PolicyArtifactsFlyout, {
    policyItem: policyItem,
    apiClient: exceptionsListApiClient,
    searchableFields: [...searchableFields],
    onClose: handleOnCloseFlyout,
    labels: labels,
    CardDecorator: CardDecorator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }), exceptionItemToDelete && /*#__PURE__*/_react.default.createElement(_delete_modal.PolicyArtifactsDeleteModal, {
    policyId: policyItem.id,
    policyName: policyItem.name,
    apiClient: exceptionsListApiClient,
    exception: exceptionItemToDelete,
    onClose: handleDeleteModalClose,
    labels: labels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_list.PolicyArtifactsList, {
    policy: policyItem,
    apiClient: exceptionsListApiClient,
    searchableFields: [...searchableFields],
    labels: labels,
    onDeleteActionCallback: handleOnDeleteActionCallback,
    canWriteArtifact: canWriteArtifact,
    getPolicyArtifactsPath: getPolicyArtifactsPath,
    getArtifactPath: getArtifactPath,
    CardDecorator: CardDecorator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  })));
});
PolicyArtifactsLayout.displayName = 'PolicyArtifactsLayout';