"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialPolicyDetailsState = void 0;
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return a fresh copy of initial state, since we mutate state in the reducer.
 */
const initialPolicyDetailsState = () => ({
  policyItem: undefined,
  isLoading: false,
  agentStatusSummary: {
    error: 0,
    events: 0,
    offline: 0,
    online: 0,
    total: 0,
    other: 0,
    all: 0,
    active: 0
  },
  artifacts: {
    location: {
      page: _constants.MANAGEMENT_DEFAULT_PAGE,
      pageSize: _constants.MANAGEMENT_DEFAULT_PAGE_SIZE,
      show: undefined,
      filter: ''
    }
  }
});
exports.initialPolicyDetailsState = initialPolicyDetailsState;