"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _notes = require("./notes");
var _management_empty_state_wrapper = require("../components/management_empty_state_wrapper");
var _constants = require("../common/constants");
var _ = require("../../app/404");
var _endpoint_hosts = require("./endpoint_hosts");
var _policy = require("./policy");
var _trusted_apps = require("./trusted_apps");
var _constants2 = require("../../../common/constants");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _event_filters = require("./event_filters");
var _routing = require("../common/routing");
var _user_privileges = require("../../common/components/user_privileges");
var _host_isolation_exceptions = require("./host_isolation_exceptions");
var _blocklist = require("./blocklist");
var _response_actions = require("./response_actions");
var _privileged_route = require("../components/privileged_route");
var _security_route_page_wrapper = require("../../common/components/security_route_page_wrapper");
var _trusted_devices = require("./trusted_devices");
var _endpoint_exceptions = require("./endpoint_exceptions");
var _scripts_library = require("./scripts_library");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.endpoints,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_endpoint_hosts.EndpointsContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.endpoints,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}));
const PolicyTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.policies,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_policy.PolicyContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.policies,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 5
  }
}));
const EndpointExceptionsTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.endpointExceptions,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_endpoint_exceptions.EndpointExceptionsContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.endpointExceptions,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 5
  }
}));
const TrustedAppTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.trustedApps,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_trusted_apps.TrustedAppsContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.trustedApps,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 5
  }
}));
const TrustedDevicesTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.trustedDevices,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_trusted_devices.TrustedDevicesContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.trustedDevices,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 5
  }
}));
const EventFilterTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.eventFilters,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_event_filters.EventFiltersContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.eventFilters,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 5
  }
}));
const HostIsolationExceptionsTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.hostIsolationExceptions,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_host_isolation_exceptions.HostIsolationExceptionsContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.hostIsolationExceptions,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 5
  }
}));
const ResponseActionsTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.responseActionsHistory,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_response_actions.ResponseActionsContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.responseActionsHistory,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 100,
    columnNumber: 5
  }
}));
const ScriptsLibraryTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.scriptsLibrary,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_scripts_library.ScriptsLibraryContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.scriptsLibrary,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 107,
    columnNumber: 5
  }
}));
const Notes = () => /*#__PURE__*/_react.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
  pageName: _constants2.SecurityPageName.notes,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 112,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_notes.NotesContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 113,
    columnNumber: 5
  }
}));
const ManagementContainer = exports.ManagementContainer = /*#__PURE__*/(0, _react.memo)(() => {
  const trustedDevicesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('trustedDevices');
  const endpointExceptionsMovedUnderManagement = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointExceptionsMovedUnderManagement');
  const showScriptsLibrary = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsScriptLibraryManagement');
  const {
    loading,
    canReadPolicyManagement,
    canReadBlocklist,
    canReadTrustedApplications,
    canReadTrustedDevices,
    canReadEventFilters,
    canReadActionsLogManagement,
    canReadEndpointList,
    canReadHostIsolationExceptions,
    canReadEndpointExceptions,
    canReadScriptsLibrary
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;

  // Lets wait until we can verify permissions
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoSecurity",
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 17
        }
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.securitySolution.endpoint.managementContainer.loadingEndpointManagement', {
        defaultMessage: 'Loading Endpoint Management'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_ENDPOINTS_PATH,
    component: EndpointTelemetry,
    hasPrivilege: canReadEndpointList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_POLICIES_PATH,
    component: PolicyTelemetry,
    hasPrivilege: canReadPolicyManagement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }), endpointExceptionsMovedUnderManagement && /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_ENDPOINT_EXCEPTIONS_PATH,
    component: EndpointExceptionsTelemetry,
    hasPrivilege: canReadEndpointExceptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_TRUSTED_APPS_PATH,
    component: TrustedAppTelemetry,
    hasPrivilege: canReadTrustedApplications,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }), trustedDevicesEnabled && /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_TRUSTED_DEVICES_PATH,
    component: TrustedDevicesTelemetry,
    hasPrivilege: canReadTrustedDevices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_EVENT_FILTERS_PATH,
    component: EventFilterTelemetry,
    hasPrivilege: canReadEventFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH,
    component: HostIsolationExceptionsTelemetry,
    hasPrivilege: canReadHostIsolationExceptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_BLOCKLIST_PATH,
    component: _blocklist.BlocklistContainer,
    hasPrivilege: canReadBlocklist,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH,
    component: ResponseActionsTelemetry,
    hasPrivilege: canReadActionsLogManagement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }), showScriptsLibrary && /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_SCRIPTS_LIBRARY_PATH,
    component: ScriptsLibraryTelemetry,
    hasPrivilege: canReadScriptsLibrary,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.MANAGEMENT_ROUTING_NOTES_PATH,
    component: Notes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }), canReadEndpointList && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.MANAGEMENT_PATH,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _routing.getEndpointListPath)({
      name: 'endpointList'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }));
});
ManagementContainer.displayName = 'ManagementContainer';