"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.osTypeBasedOnAgentType = exports.getInitialExceptionFromEvent = void 0;
var _uuid = require("uuid");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const osTypeBasedOnAgentType = data => {
  var _data$agent, _data$agent$type;
  if (data !== null && data !== void 0 && (_data$agent = data.agent) !== null && _data$agent !== void 0 && (_data$agent$type = _data$agent.type) !== null && _data$agent$type !== void 0 && _data$agent$type.includes('endpoint')) {
    var _data$host, _data$host$os;
    return ((data === null || data === void 0 ? void 0 : (_data$host = data.host) === null || _data$host === void 0 ? void 0 : (_data$host$os = _data$host.os) === null || _data$host$os === void 0 ? void 0 : _data$host$os.name) || ['windows']).map(name => name.toLowerCase());
  } else {
    var _data$host$os$family, _data$host2, _data$host2$os;
    return (_data$host$os$family = data === null || data === void 0 ? void 0 : (_data$host2 = data.host) === null || _data$host2 === void 0 ? void 0 : (_data$host2$os = _data$host2.os) === null || _data$host2$os === void 0 ? void 0 : _data$host2$os.family) !== null && _data$host$os$family !== void 0 ? _data$host$os$family : ['windows'];
  }
};
exports.osTypeBasedOnAgentType = osTypeBasedOnAgentType;
const getInitialExceptionFromEvent = data => {
  var _data$event$category, _data$process$executa;
  return {
    comments: [],
    description: '',
    entries: data && data.event && data.process ? [{
      field: 'event.category',
      operator: 'included',
      type: 'match',
      value: ((_data$event$category = data.event.category) !== null && _data$event$category !== void 0 ? _data$event$category : [])[0]
    }, {
      field: 'process.executable',
      operator: 'included',
      type: 'match',
      value: ((_data$process$executa = data.process.executable) !== null && _data$process$executa !== void 0 ? _data$process$executa : [])[0]
    }] : [{
      field: '',
      operator: 'included',
      type: 'match',
      value: ''
    }],
    item_id: undefined,
    list_id: _constants.ENDPOINT_EVENT_FILTERS_LIST_ID,
    meta: {
      temporaryUuid: (0, _uuid.v4)()
    },
    name: '',
    namespace_type: 'agnostic',
    tags: ['policy:all'],
    type: 'simple',
    os_types: osTypeBasedOnAgentType(data)
  };
};
exports.getInitialExceptionFromEvent = getInitialExceptionFromEvent;