"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreationSuccessMessage = exports.getCreationErrorMessage = exports.EVENT_FILTERS_PROCESS_DESCENDANT_DECORATOR_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCreationSuccessMessage = item => {
  return _i18n.i18n.translate('xpack.securitySolution.eventFilter.flyoutForm.creationSuccessToastTitle', {
    defaultMessage: '"{name}" has been added to the event filters list.',
    values: {
      name: item === null || item === void 0 ? void 0 : item.name
    }
  });
};
exports.getCreationSuccessMessage = getCreationSuccessMessage;
const getCreationErrorMessage = creationError => {
  return {
    title: _i18n.i18n.translate('xpack.securitySolution.eventFilter.flyoutForm.creationErrorToastTitle', {
      defaultMessage: 'There was an error creating the new event filter.'
    }),
    message: {
      error: creationError.message
    }
  };
};
exports.getCreationErrorMessage = getCreationErrorMessage;
const EVENT_FILTERS_PROCESS_DESCENDANT_DECORATOR_LABELS = exports.EVENT_FILTERS_PROCESS_DESCENDANT_DECORATOR_LABELS = {
  title: _i18n.i18n.translate('xpack.securitySolution.eventFilter.processDescendantsIndicator.title', {
    defaultMessage: 'Filtering descendants of process'
  }),
  tooltipText: _i18n.i18n.translate('xpack.securitySolution.eventFilter.processDescendantsIndicator.tooltipText', {
    defaultMessage: 'Filtering the descendants of a process means that events from the matched process are ingested, but events from its descendant processes are omitted.'
  }),
  versionInfo: _i18n.i18n.translate('xpack.securitySolution.eventFilter.processDescendantsIndicator.versionInfo', {
    defaultMessage: 'Process descendant filtering works only with Agents v8.15+.'
  })
};